<?= $this->extend('layouts/theme-backend') ?>

<?= $this->section('content') ?>
<h1 class="h2 mb-3 text-gray-900"><?= $title; ?></h1>

<div id="content">
   <div class="card shadow mb-4">
      <div class="card-body">
         <a href="<?= base_url('admin/users/new'); ?>" class="btn btn-primary mb-4">Tambah User</a>
         <div class="table-responsive">
            <table class="m-0 font-weight-bold table">
               <thead>
                  <tr>
                     <th>No</th>
                     <th>Username</th>
                     <th>Email</th>
                     <th>Nama</th>
                     <th>Akses</th>
                     <th>Aksi</th>
                  </tr>
               </thead>
               <tbody>
                  <?php $no = 1;
                  foreach ($users as $user) : ?>
                     <tr>
                        <td><?= $no++; ?></td>
                        <td><?= $user['username']; ?></td>
                        <td><?= $user['email']; ?></td>
                        <td><?= $user['nama']; ?></td>
                        <td><?php
                              if ($user['roles'] === '1') {
                                 echo "Admin";
                              } else {
                                 echo "User";
                              }
                              ?>
                        </td>
                        <td>
                           <a href="<?= base_url('admin/users/edit/' . $user['id']) ?>" class="btn btn-primary">Edit</a>
                           <form action="<?= base_url('admin/users/delete/'. $user['id']); ?>" method="POST" class="d-inline-block">
                              <?= csrf_field(); ?>
                              <input type="hidden" name="_method" value="DELETE">
                              <button type="submit" class="btn btn-danger text-light" onclick="return confirm('Apakah anda yakin menghapus data ini?')">Hapus</button>
                           </form>
                        </td>
                     </tr>
                  <?php endforeach; ?>
               </tbody>
            </table>
         </div>
      </div>
   </div>
</div>
<?= $this->endSection() ?>