<?= $this->extend('layouts/theme-backend') ?>

<?= $this->section('content') ?>
<h1 class="h2 mb-3 text-gray-900">Edit User <?= $user['nama']; ?></h1>

<div id="content">
   <div class="card shadow mb-4">
      <div class="card-body">
         <div class="row">
            <div class="col-md-6">
               <?= form_open('/admin/users/update/' . $user['id']) ?>
               <?= csrf_field(); ?>
               <div class="form-group">
                  <label for="email">Email Address</label>
                  <input type="email" name="email" id="email" class="form-control <?= (validation_show_error('email') ? "is-invalid" : "") ?>" value="<?= $user['email'] ?>">
                  <div class="invalid-feedback">
                     <?= validation_show_error('email') ?>
                  </div>
               </div>

               <div class="form-group">
                  <label for="nama">Nama Lengkap</label>
                  <input type="text" name="nama" id="nama" class="form-control <?= (validation_show_error('nama') ? "is-invalid" : "") ?>" value="<?= $user['nama'] ?>">
                  <div class="invalid-feedback">
                     <?= validation_show_error('nama') ?>
                  </div>
               </div>

               <?php if ($user['username'] != 'admin') { ?>
                  <div class="form-group">
                     <label for="username">Username</label>
                     <input type="text" name="username" id="username" class="form-control <?= (validation_show_error('username') ? "is-invalid" : "") ?>" value="<?= $user['username'] ?>">
                     <div class="invalid-feedback">
                        <?= validation_show_error('username') ?>
                     </div>
                  </div>
               <?php } else { ?>
                  <input type="hidden" name="username" value="<?= $user['username'] ?>">
               <?php } ?>
               <div class="form-group">
                  <label for="password">Password</label>
                  <input type="password" name="password" id="password" class="form-control">
                  <p class="small text-muted my-1">Kosongkan jika tidak ingin mengubahnya</p>
               </div>

               <?php if ($user['username'] != 'admin') { ?>
               <div class="form-group">
                  <label for="roles">Hak Akses</label>
                  <select name="roles" id="roles" class="form-control <?= (validation_show_error('roles') ? "is-invalid" : "") ?>">
                     <option value="">-- Hak Akses --</option>
                     <option value="1" <?php if ($user['roles'] === '1') { ?> <?php echo "selected"; ?> <?php } ?>>Administrator</option>
                     <option value="2" <?php if ($user['roles'] === '2') { ?> <?php echo "selected"; ?> <?php } ?>>User</option>
                  </select>
                  <div class="invalid-feedback">
                     <?= validation_show_error('roles') ?>
                  </div>
               </div>
               <?php } else { ?>
                  <input type="hidden" name="roles" value="<?= $user['roles'] ?>">
               <?php } ?>

               <div class="form-group">
                  <button type="submit" class="btn btn-primary btn-lg">Update</button>
               </div>
               <?= form_close(); ?>
            </div>
         </div>
      </div>
   </div>
</div>
<?= $this->endSection() ?>