<?= $this->extend('layouts/theme-backend') ?>

<?= $this->section('content') ?>
<h1 class="h2 mb-3 text-gray-900">Edit Slideshow <?= $slideshow['judul_slide']; ?></h1>

<?php if (session()->getFlashdata('success')): ?>
   <div class="alert alert-success alert-dismissible fade show" role="alert">
      <?= session()->getFlashdata('success') ?>
      <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
   </div>
<?php endif; ?>

<?php if (session()->getFlashdata('error')): ?>
   <div class="alert alert-danger alert-dismissible fade show" role="alert">
      <?= session()->getFlashdata('error') ?>
      <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
   </div>
<?php endif; ?>

<?php if (isset($errors) && !empty($errors)): ?>
   <div class="alert alert-warning alert-dismissible fade show" role="alert">
      <strong>Validation Errors:</strong>
      <ul class="mb-0">
         <?php foreach ($errors as $error): ?>
            <li><?= $error ?></li>
         <?php endforeach; ?>
      </ul>
      <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
   </div>
<?php endif; ?>

<div id="content">
   <div class="card shadow mb-4">
      <div class="card-body">
         <div class="row">
            <div class="col-md-6">
               <?= form_open_multipart('/admin/slideshow/update/' . $slideshow['id']) ?>
               <?= csrf_field(); ?>
               <input type="hidden" name="foto_slide_lama" id="foto_slide_lama" value="<?= $slideshow['foto_slide']; ?>">
               <div class="form-group">
                  <label for="judul_slide">Judul Slide</label>
                  <input type="text" name="judul_slide" id="judul_slide" class="form-control <?= (validation_show_error('judul_slide') ? "is-invalid" : "") ?>" value="<?= $slideshow['judul_slide']; ?>">
                  <div class="invalid-feedback">
                     <?= validation_show_error('judul_slide') ?>
                  </div>
               </div>
               <div class="form-group">
                  <label for="deskripsi_slide">Deskripsi Slide</label>
                  <textarea name="deskripsi_slide" id="deskripsi_slide" class="form-control <?= (validation_show_error('deskripsi_slide') ? "is-invalid" : "") ?>" rows="4"><?= $slideshow['deskripsi_slide']; ?></textarea>
                  <div class="invalid-feedback">
                     <?= validation_show_error('deskripsi_slide') ?>
                  </div>
               </div>
               <div class="form-group">
                  <label for="foto_slide">Foto <small>(Format .jpg, .jpeg, .png)</small></label><br>
                  <img src="<?= base_url('img/slideshow/' . $slideshow['foto_slide']) ?>" alt="" class="img-fluid mb-3">
                  <input type="file" name="foto_slide" id="foto_slide" class="form-control-file <?= (validation_show_error('foto_slide') ? "is-invalid" : "") ?>" onchange="readFoto(event)">
                  <div class="invalid-feedback">
                     <?= validation_show_error('foto_slide') ?>
                  </div>
                  <img id='output' class="mt-3 mb-0" style="width: 400px;">
               </div>
               <div class="form-group">
                  <label for="status">Status</label>
                  <select name="status" id="status" class="form-control <?= (validation_show_error('status') ? "is-invalid" : "") ?>">
                     <option value="">-- Pilih Status --</option>
                     <option value="0" <?= ($slideshow['status'] == 0 ? 'selected' : '') ?>>Tidak Aktif</option>
                     <option value="1" <?= ($slideshow['status'] == 1 ? 'selected' : '') ?>>Aktif</option>
                  </select>
                  <div class="invalid-feedback">
                     <?= validation_show_error('status') ?>
                  </div>
               </div>
               <div class="form-group mt-4">
                  <button type="submit" class="btn btn-primary btn-lg">Update</button>
               </div>
               <?= form_close(); ?>
            </div>
         </div>
      </div>
   </div>
</div>
<?= $this->endSection() ?>