<?= $this->extend('layouts/theme-backend') ?>

<?= $this->section('content') ?>
<h1 class="h2 mb-3 text-gray-900"><?= $title; ?></h1>

<div id="content">
   <div class="card shadow mb-4">
      <div class="card-body">
      <a href="<?= base_url('admin/galeri/new'); ?>" class="btn btn-primary mb-4">Tambah Galeri</a>
         <div class="table-responsive">
            <table class="m-0 font-weight-bold table">
               <thead>
                  <tr>
                     <th>No</th>
                     <th>Foto</th>
                     <th>Galeri</th>
                     <th>Aksi</th>
                  </tr>
               </thead>
               <tbody>
                  <?php $no = 1;
                  foreach ($galeri as $g) : ?>
                     <tr>
                        <td><?= $no++; ?></td>
                        <td>
                           <img src="<?= base_url('img/galeri/' . $g['foto_galeri']) ?>" width="100" class="img-fluid">
                        </td>
                        <td><?= $g['nama_galeri']; ?></td>
                        <td>
                           <a href="<?= base_url('admin/galeri/edit/' . $g['id']) ?>" class="btn btn-primary">Edit</a>
                           <form action="<?= base_url('admin/galeri/delete/'. $g['id']); ?>" method="POST" class="d-inline-block">
                              <?= csrf_field(); ?>
                              <input type="hidden" name="_method" value="DELETE">
                              <button type="submit" class="btn btn-danger text-light" onclick="return confirm('Apakah anda yakin menghapus data ini?')">Hapus</button>
                           </form>
                        </td>
                     </tr>
                  <?php endforeach; ?>
               </tbody>
            </table>
         </div>
      </div>
   </div>
</div>
<?= $this->endSection() ?>