<?= $this->extend('layouts/theme-backend') ?>

<?= $this->section('content') ?>
<h1 class="h2 mb-3 text-gray-900"><?= $title; ?></h1>

<div id="content">
   <div class="card shadow mb-4">
      <div class="card-body">
         <div class="row">
            <div class="col-md-6">
               <?= form_open_multipart('/admin/fasilitas/create') ?>
               <?= csrf_field(); ?>
               <div class="form-group">
                  <label for="fasilitas">Fasilitas</label>
                  <input type="text" name="fasilitas" id="fasilitas" class="form-control <?= (validation_show_error('fasilitas') ? "is-invalid" : "") ?>" value="<?= set_value('fasilitas') ?>">
                  <div class="invalid-feedback">
                     <?= validation_show_error('fasilitas') ?>
                  </div>
               </div>
               <div class="form-group">
                  <label for="deskripsi">Deskripsi</label>
                  <textarea name="deskripsi" id="deskripsi" class="form-control <?= (validation_show_error('deskripsi') ? "is-invalid" : "") ?>" value="<?= set_value('deskripsi') ?>"></textarea>
                  <div class="invalid-feedback">
                     <?= validation_show_error('deskripsi') ?>
                  </div>
               </div>
               <div class="form-group">
                  <label for="foto_fasilitas">Foto <small>(Format .jpg, .jpeg, .png)</small></label>
                  <input type="file" name="foto_fasilitas" id="foto_fasilitas" class="form-control-file <?= (validation_show_error('foto_fasilitas') ? "is-invalid" : "") ?>" onchange="readFoto(event)">
                  <div class="invalid-feedback">
                     <?= validation_show_error('foto_fasilitas') ?>
                  </div>
                  <img id='output' class="mt-3 mb-0" style="width: 400px;">
               </div>
               <div class="form-group mt-4">
                  <button type="submit" class="btn btn-primary btn-lg">Simpan</button>
               </div>
               <?= form_close(); ?>
            </div>
         </div>
      </div>
   </div>
</div>
<?= $this->endSection() ?>