<?= $this->extend('layouts/theme-backend') ?>

<?= $this->section('content') ?>
<h1 class="h2 mb-3 text-gray-900"><?= $title; ?></h1>

<div id="content">
   <div class="card shadow mb-4">
      <div class="card-body">
      <a href="<?= base_url('admin/siswa/new'); ?>" class="btn btn-primary mb-4">Tambah <?= $title; ?></a>
         <div class="table-responsive">
         <input type="hidden" name="<?= csrf_token() ?>" value="<?= csrf_hash() ?>" id="csrfSecure" />
            <table class="m-0 font-weight-bold table" id="datatable" cellspacing="0" width="100%">
               <thead>
                  <tr>
                     <th>No</th>
                     <th>NISN</th>
                     <th>Nama</th>
                     <th>Tempat Lahir</th>
                     <th>Tanggal Lahir</th>
                     <th>Jenis Kelamin</th>
                     <th>Telepon</th>
                     <th>Alamat</th>
                     <th>Aksi</th>
                  </tr>
               </thead>
            </table>
         </div>
      </div>
   </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('script') ?>
<script>
   $(document).ready(function() {
      $('[data-bs-toggle="tooltip"]').tooltip();
      var table = $('#datatable').on('draw.dt', function() {
         $('[data-bs-toggle="tooltip"]').tooltip();
      }).DataTable({
         "lengthMenu": [
            [10, 20, 50, -1],
            [10, 20, 50, "All"]
         ],
         'destroy': true,
         'responsive': true,
         'processing': true,
         'serverSide': true,
         'order': [],
         'ajax': {
            'url': '<?= base_url('admin/siswa/listdata'); ?>',
            'type': 'POST',
            "data": {
               <?= csrf_token() ?>: $('input[name=<?= csrf_token() ?>]').val(),
            },
            "data": function(data) {
               data.<?= csrf_token() ?> = $('input[name=<?= csrf_token() ?>]').val()
            },
            "dataSrc": function(response) {
               $('input[name=<?= csrf_token() ?>]').val(response.<?= csrf_token() ?>);
               return response.data;
            },
         },
         'columnDefs': [{
            'targets': [0, 8], //sesuaikan kolom yang tidak mau di sort
            'orderable': false
         }, ],
      })

      $('.tooltip').not(this).tooltip('hide');
   })
</script>
<?= $this->endSection('script'); ?>