<?= $this->extend('layouts/theme-backend') ?>

<?= $this->section('content') ?>
<h1 class="h2 mb-3 text-gray-900">Edit Pengumuman <?= $pengumuman['judul_pengumuman'] ?></h1>

<div id="content">
   <div class="card shadow mb-4">
      <div class="card-body">
         <div class="row">
            <div class="col-md-12">
               <?= form_open_multipart('/admin/pengumuman/update/' . $pengumuman['id']) ?>
               <?= csrf_field(); ?>
               <input type="hidden" name="foto_pengumuman_lama" id="foto_pengumuman_lama" value="<?= $pengumuman['foto_pengumuman']; ?>">

               <div class="form-group">
                  <label for="judul_pengumuman">Judul Pengumuman</label>
                  <input type="text" name="judul_pengumuman" id="judul_pengumuman" class="form-control <?= (validation_show_error('judul_pengumuman') ? "is-invalid" : "") ?>" required value="<?= $pengumuman['judul_pengumuman']; ?>">
                  <div class="invalid-feedback">
                     <?= validation_show_error('judul_pengumuman') ?>
                  </div>
               </div>
               <div class="form-group">
                  <label for="isi_pengumuman">Deskripsi</label>
                  <textarea name="isi_pengumuman" id="isi" class="form-control <?= (validation_show_error('isi_pengumuman') ? "is-invalid" : "") ?>"><?= $pengumuman['isi_pengumuman'] ?></textarea>
                  <div class="invalid-feedback">
                     <?= validation_show_error('isi_pengumuman') ?>
                  </div>
               </div>
               <div class="form-group">
                  <label>Foto</label><br />
                  <img src="<?= base_url('img/pengumuman/' . $pengumuman['foto_pengumuman']) ?>" alt="" class="img-fluid">
               </div>
               <div class="form-group">
                  <label for="foto_pengumuman">Ganti Foto <small>(Format .jpg, .jpeg, .png)</small></label><br>
                  <input type="file" name="foto_pengumuman" id="foto_pengumuman" class="form-control-file <?= (validation_show_error('foto_pengumuman') ? "is-invalid" : "") ?>" onchange="readFoto(event)">
                  <div class="invalid-feedback">
                     <?= validation_show_error('foto_pengumuman') ?>
                  </div>
                  <img id='output' class="mt-3 mb-0" style="width: 400px;">
               </div>
               <div class="form-group mt-4">
                  <button type="submit" class="btn btn-primary btn-lg">Update</button>
               </div>
               <?= form_close(); ?>
            </div>
         </div>
      </div>
   </div>
</div>
<?= $this->endSection() ?>