<?= $this->extend('layouts/theme-backend') ?>

<?= $this->section('content') ?>
<h1 class="h2 mb-3 text-gray-900"><?= $title; ?></h1>

<div id="content">
   <div class="card shadow mb-4">
      <div class="card-body">
         <div class="row">
            <div class="col-md-12">
               <?= form_open_multipart('/admin/pengumuman/create') ?>
               <?= csrf_field(); ?>
               <div class="form-group">
                  <label for="judul_pengumuman">Judul Pengumuman</label>
                  <input type="text" name="judul_pengumuman" id="judul_pengumuman" class="form-control <?= (validation_show_error('judul_pengumuman') ? "is-invalid" : "") ?>" value="<?= set_value('judul_pengumuman') ?>">
                  <div class="invalid-feedback">
                     <?= validation_show_error('judul_pengumuman') ?>
                  </div>
               </div>
               <div class="form-group">
                  <label for="isi_pengumuman">Deskripsi</label>
                  <textarea name="isi_pengumuman" id="isi" class="form-control <?= (validation_show_error('isi_pengumuman') ? "is-invalid" : "") ?>" value="<?= set_value('isi_pengumuman') ?>"></textarea>
                  <div class="invalid-feedback">
                     <?= validation_show_error('isi_pengumuman') ?>
                  </div>
               </div>
               <div class="form-group">
                  <label for="foto_pengumuman">Foto <small>(Format .jpg, .jpeg, .png)</small></label>
                  <input type="file" name="foto_pengumuman" id="foto_pengumuman" class="form-control-file <?= (validation_show_error('foto_pengumuman') ? "is-invalid" : "") ?>" onchange="readFoto(event)">
                  <div class="invalid-feedback">
                     <?= validation_show_error('foto_pengumuman') ?>
                  </div>
                  <img id='output' class="mt-3 mb-0" style="width: 400px;">
               </div>
               <div class="form-group mt-4">
                  <button type="submit" class="btn btn-primary btn-lg">Simpan</button>
               </div>
               <?= form_close(); ?>
            </div>
         </div>
      </div>
   </div>
</div>
<?= $this->endSection() ?>