<?= $this->extend('layouts/theme-backend') ?>

<?= $this->section('content') ?>
<h1 class="h2 mb-3 text-gray-900"><?= $title; ?></h1>

<div id="content">
   <div class="card shadow mb-4">
      <div class="card-body">
         <?= form_open_multipart('admin/kepsek/update/' . $kepsek['id']); ?>
         <div class="row">
            <div class="col-md-8">
               <div class="form-group">
                  <label for="nama_kepsek">Nama Kepala Sekolah & Gelar</label>
                  <input type="text" name="nama_kepsek" id="nama_kepsek" class="form-control <?= (validation_show_error('nama_kepsek') ? "is-invalid" : "") ?>" value="<?= $kepsek['nama_kepsek'] ?>">
                  <div class="invalid-feedback">
                     <?= validation_show_error('nama_kepsek') ?>
                  </div>
               </div>
               <div class="form-group">
                  <label for="kata_sambutan">Kata Sambutan</label>
                  <textarea name="kata_sambutan" id="isi" class="form-control <?= (validation_show_error('kata_sambutan') ? "is-invalid" : "") ?>" value="Kata Sambutan"><?= $kepsek['kata_sambutan'] ?></textarea>
                  <div class="invalid-feedback">
                     <?= validation_show_error('kata_sambutan') ?>
                  </div>
               </div>
               <div class="form-group">
                  <button type="submit" class="btn btn-primary btn-lg">Simpan</button>
               </div>
            </div>
            <div class="col-md-4">
               <img src="<?= base_url('img/kepsek/' . $kepsek['foto_kepsek']) ?>" class="img-fluid mb-3">
               <div class="form-group">
                  <input type="file" name="foto_kepsek" id="foto_kepsek" class="form-control-file">
                  <input type="hidden" name="foto_kepsek_lama" id="foto_kepsek_lama" class="form-control" value="<?= $kepsek['foto_kepsek'] ?>">
               </div>
            </div>
         </div>
         <?= form_close(); ?>
      </div>
   </div>
</div>
<?= $this->endSection() ?>