<?= $this->extend('layouts/theme-backend') ?>

<?= $this->section('content') ?>
<h1 class="h2 mb-3 text-gray-900">Edit Guru <?= $guru['nama_guru']; ?></h1>

<div id="content">
   <div class="card shadow mb-4">
      <div class="card-body">
         <div class="row">
            <div class="col-md-6">
               <?= form_open_multipart('/admin/guru/update/' . $guru['id']); ?>
               <?= csrf_field(); ?>
               <div class="form-group">
                  <label for="nip_nik">NIP/NIK</label>
                  <input type="text" name="nip_nik" id="nip_nik" class="form-control <?= (validation_show_error('nip_nik') ? "is-invalid" : "") ?>" value="<?= $guru['nip_nik']; ?>">
                  <div class="invalid-feedback">
                     <?= validation_show_error('nip_nik') ?>
                  </div>
               </div>
               <div class="form-group">
                  <label for="nama_guru">Nama Lengkap</label>
                  <input type="text" name="nama_guru" id="nama_guru" class="form-control <?= (validation_show_error('nama_guru') ? "is-invalid" : "") ?>" value="<?= $guru['nama_guru']; ?>">
                  <div class="invalid-feedback">
                     <?= validation_show_error('nama_guru') ?>
                  </div>
               </div>
               <div class="form-group">
                  <label for="email">Email</label>
                  <input type="email" name="email" id="email" class="form-control" value="<?= $guru['email']; ?>">
               </div>
               <div class="form-group">
                  <label for="foto_guru">Ganti Foto</label><br>
                  <input type="file" name="foto_guru" id="foto_guru" class="form-control">
                  <input type="hidden" name="foto_guru_lama" id="foto_guru_lama" class="form-control" value="<?= $guru['foto_guru']; ?>">
               </div>
               <div class="form-group">
                  <label for="jabatan">Jabatan</label>
                  <input type="text" name="jabatan" id="jabatan" class="form-control <?= (validation_show_error('jabatan') ? "is-invalid" : "") ?>" value="<?= $guru['jabatan']; ?>">
                  <div class="invalid-feedback">
                     <?= validation_show_error('jabatan') ?>
                  </div>
               </div>
               <div class="form-group">
                  <button type="submit" class="btn btn-primary btn-lg">Update</button>
               </div>
               <?= form_close(); ?>
            </div>
            <div class="col-md-6">
            <img src="<?= base_url('img/guru/' . $guru['foto_guru']) ?>" alt="" class="img-fluid" width="200">
            </div>
         </div>
      </div>
   </div>
</div>
<?= $this->endSection() ?>