<?php

namespace App\Controllers;

use App\Models\KepsekModel;
use App\Models\FasilitasModel;
use App\Models\ArtikelModel;
use App\Models\PengaturanwebModel;
use App\Models\EkstrakurikulerModel;
use App\Models\GaleriModel;
use App\Models\MateriModel;
use App\Models\PengumumanModel;
use App\Models\KontakModel;
use App\Models\MateriDataModel;
use App\Models\GuruDataModel;
use App\Models\SlideshowModel;
use Config\Services;

class Home extends BaseController
{
	public function __construct()
	{
		$this->kepsekModel = new KepsekModel();
		$this->fasilitasModel = new FasilitasModel();
		$this->artikelModel = new ArtikelModel();
		$this->settingModel = new PengaturanwebModel();
		$this->ekstraModel = new EkstrakurikulerModel();
		$this->galeriModel = new GaleriModel();
		$this->materiModel = new MateriModel();
		$this->pengumumanModel = new PengumumanModel();
		$this->kontakModel = new KontakModel();
		$this->slideshowModel = new SlideshowModel();
	}

	public function index()
	{
		$showLimit = 3;
		return view('home', [
			'title' => 'Home',
			'kepsek' => $this->kepsekModel->first(),
			'fasilitaslimit3' => $this->fasilitasModel->findAll(3),
			'artikel' => $this->artikelModel->loadmoreArtikel('', $showLimit),
			'berita' => $this->artikelModel->orderBy('id', 'DESC')->findAll(3),
			'fasilitas' => $this->fasilitasModel->findAll(),
			'setting' => $this->settingModel->first(),
			'ekstra' => $this->ekstraModel->findAll(),
			'info' => $this->pengumumanModel->first(),
			'slideshow' => $this->slideshowModel->where('status', 1)->findAll(),
			'validation' => $this->validation,
		]);
	}

	public function load_more()
	{
		if ($this->request->getVar('id')) {
			$csrfName = csrf_token();
			$csrfHash = csrf_hash();

			$showLimit = 3;
			$id = $this->request->getVar('id');

			$totalRowCount = $this->artikelModel->countLoadmoreArtikel($id);
			$artikel = $this->artikelModel->loadmoreArtikel($id, $showLimit);

			$data = [
				'total' => $totalRowCount,
				'limit' => $showLimit,
				'artikel' => $artikel
			];
			$data[$csrfName] = $csrfHash;
			return view('load_more', $data);
		}
	}

	public function sambutan_kepsek()
	{
		return view('page/sambutan', [
			'title' =>  'Sambutan Kepala Sekolah',
			'kepsek' => $this->kepsekModel->first(),
			'setting' => $this->settingModel->first(),
			'info' => $this->pengumumanModel->first(),
			'berita' => $this->artikelModel->orderBy('id', 'DESC')->findAll(3),
			'fasilitas' => $this->fasilitasModel->findAll(),
			'ekstra' => $this->ekstraModel->findAll(),
		]);
	}

	public function struktur_organisasi()
	{
		return view('page/strukturorganisasi', [
			'title' =>  'Struktur Organisasi',
			'setting' => $this->settingModel->first(),
			'info' => $this->pengumumanModel->first(),
			'berita' => $this->artikelModel->orderBy('id', 'DESC')->findAll(3),
			'fasilitas' => $this->fasilitasModel->findAll(),
			'ekstra' => $this->ekstraModel->findAll(),
		]);
	}

	public function guru()
	{
		return view('page/guru', [
			'title' => 'Guru & Staf',
			'setting' => $this->settingModel->first(),
			'materi' => $this->materiModel->findAll(),
			'info' => $this->pengumumanModel->first(),
			'berita' => $this->artikelModel->orderBy('id', 'DESC')->findAll(3),
			'fasilitas' => $this->fasilitasModel->findAll(),
			'ekstra' => $this->ekstraModel->findAll(),
		]);
	}

	public function guru_listData()
    {
        $request = Services::request();
        $datamodel = new GuruDataModel($request);
        if ($request->getMethod(true) == 'POST') {
            $lists = $datamodel->get_datatables();
            $csrfName = csrf_token();
            $csrfHash = csrf_hash();
            $data = [];
            $no = $request->getPost("start");
            foreach ($lists as $list) {
                $no++;
                $row = [];

				$foto = "<img src='".base_url()."/img/guru/".$list->foto_guru."' alt=\"Foto Guru $list->nama_guru\" class=\"\" width=\"100\">";

                $row[] = $no;
				$row[] = $foto;
                $row[] = $list->nip_nik;
                $row[] = $list->nama_guru;
				$row[] = $list->jabatan;
                $data[] = $row;
            }
            $output = [
                "draw" => $request->getPost('draw'),
                "recordsTotal" => $datamodel->count_all(),
                "recordsFiltered" => $datamodel->count_filtered(),
                "data" => $data
            ];
            $output[$csrfName] = $csrfHash;
            echo json_encode($output);
        }
    }

	public function fasilitas()
	{
		$fasilitas = $this->fasilitasModel->findAll();
		return view('page/fasilitas', [
			'title' =>  'Fasilitas',
			'semuafasilitas' => $fasilitas,
			'setting' => $this->settingModel->first(),
			'info' => $this->pengumumanModel->first(),
			'berita' => $this->artikelModel->orderBy('id', 'DESC')->findAll(3),
			'fasilitas' => $this->fasilitasModel->findAll(),
			'ekstra' => $this->ekstraModel->findAll(),
		]);
	}

	public function ekstrakurikuler()
	{
		$ekstrakurikuler = $this->ekstraModel->findAll();
		return view('page/ekstrakurikuler', [
			'title' =>  'Ekstrakurikuler',
			'ekstrakurikuler' => $ekstrakurikuler,
			'setting' => $this->settingModel->first(),
			'info' => $this->pengumumanModel->first(),
			'berita' => $this->artikelModel->orderBy('id', 'DESC')->findAll(3),
			'fasilitas' => $this->fasilitasModel->findAll(),
			'ekstra' => $this->ekstraModel->findAll(),
		]);
	}

	public function galeri()
	{
		return view('page/galeri', [
			'title' => 'Galeri',
			'setting' => $this->settingModel->first(),
			'galeri' => $this->galeriModel->findAll(),
			'info' => $this->pengumumanModel->first(),
			'berita' => $this->artikelModel->orderBy('id', 'DESC')->findAll(3),
			'fasilitas' => $this->fasilitasModel->findAll(),
			'ekstra' => $this->ekstraModel->findAll(),
			// 'materi' => $this->materiModel->findAll(),
		]);
	}

	public function materi()
	{
		return view('page/materi', [
			'title' => 'Materi',
			'setting' => $this->settingModel->first(),
			'materi' => $this->materiModel->findAll(),
			'info' => $this->pengumumanModel->first(),
			'berita' => $this->artikelModel->orderBy('id', 'DESC')->findAll(3),
			'fasilitas' => $this->fasilitasModel->findAll(),
			'ekstra' => $this->ekstraModel->findAll(),
		]);
	}

	public function materi_listData()
    {
        $request = Services::request();
        $datamodel = new MateriDataModel($request);
        if ($request->getMethod(true) == 'POST') {
            $lists = $datamodel->get_datatables();
            $csrfName = csrf_token();
            $csrfHash = csrf_hash();
            $data = [];
            $no = $request->getPost("start");
            foreach ($lists as $list) {
                $no++;
                $row = [];

                $btnLihat= "<a href='" . base_url() . "/materi/lihat/$list->id' class=\"btn bg-primary btn-sm text-white me-2\" data-bs-toggle=\"tooltip\" title=\"Lihat Data\" target='_blank'>Lihat</a>";

                $row[] = $no;
                $row[] = $list->materi;
                $row[] = $btnLihat;
                $data[] = $row;
            }
            $output = [
                "draw" => $request->getPost('draw'),
                "recordsTotal" => $datamodel->count_all(),
                "recordsFiltered" => $datamodel->count_filtered(),
                "data" => $data
            ];
            $output[$csrfName] = $csrfHash;
            echo json_encode($output);
        }
    }

	public function lihat_materi($id)
	{
		$materi = $this->materiModel->find($id);
		return view('page/lihat-pdf', [
			'materi' => $materi,
		]);
	}

	public function pengumuman()
	{
		$showLimit = 5;
		return view('page/pengumuman', [
			'title' => 'Pengumuman',
			'pengumuman' => $this->pengumumanModel->loadmorePengumuman('', $showLimit),
			'setting' => $this->settingModel->first(),
			'info' => $this->pengumumanModel->first(),
			'berita' => $this->artikelModel->orderBy('id', 'DESC')->findAll(3),
			'fasilitas' => $this->fasilitasModel->findAll(),
			'ekstra' => $this->ekstraModel->findAll(),
		]);
	}

	public function loadmore_pengumuman()
	{
		if ($this->request->getVar('id')) {
			$csrfName = csrf_token();
			$csrfHash = csrf_hash();

			$showLimit = 5;
			$id = $this->request->getVar('id');

			$totalRowCount = $this->pengumumanModel->countLoadmorePengumuman($id);
			$pengumuman = $this->pengumumanModel->loadmorePengumuman($id, $showLimit);

			$data = [
				'total' => $totalRowCount,
				'limit' => $showLimit,
				'pengumuman' => $pengumuman
			];
			$data[$csrfName] = $csrfHash;
			return view('page/loadmore_pengumuman', $data);
		}
	}

	public function detail_pengumuman($id)
	{
		$pengumuman = $this->pengumumanModel->find($id);
		return view('page/pengumumandetail', [
			'title' =>  $pengumuman['judul_pengumuman'] . '',
			'pengumuman' => $pengumuman,
			'setting' => $this->settingModel->first(),
			'info' => $this->pengumumanModel->findAll(),
			'berita' => $this->artikelModel->orderBy('id', 'DESC')->findAll(3),
			'fasilitas' => $this->fasilitasModel->findAll(),
			'ekstra' => $this->ekstraModel->findAll(),
		]);
	}

	public function berita()
	{
		$showLimit = 5;
		return view('page/berita', [
			'title' =>  'Berita',
			'artikel' => $this->artikelModel->loadmoreArtikel('', $showLimit),
			'setting' => $this->settingModel->first(),
			'info' => $this->pengumumanModel->findAll(),
			'berita' => $this->artikelModel->orderBy('id', 'DESC')->findAll(3),
			'fasilitas' => $this->fasilitasModel->findAll(),
			'ekstra' => $this->ekstraModel->findAll(),
		]);
	}

	public function loadmore_berita()
	{
		if ($this->request->getVar('id')) {
			$csrfName = csrf_token();
			$csrfHash = csrf_hash();

			$showLimit = 5;
			$id = $this->request->getVar('id');

			$totalRowCount = $this->artikelModel->countLoadmoreArtikel($id);
			$artikel = $this->artikelModel->loadmoreArtikel($id, $showLimit);

			$data = [
				'total' => $totalRowCount,
				'limit' => $showLimit,
				'artikel' => $artikel
			];
			$data[$csrfName] = $csrfHash;
			return view('page/loadmore_berita', $data);
		}
	}

	public function detail_berita($id)
	{
		$artikel = $this->artikelModel->find($id);
		return view('page/beritadetail', [
			'title' =>  $artikel['judul'] . '',
			'artikel' => $artikel,
			'setting' => $this->settingModel->first(),
			'info' => $this->pengumumanModel->findAll(),
			'berita' => $this->artikelModel->orderBy('id', 'DESC')->findAll(3),
			'fasilitas' => $this->fasilitasModel->findAll(),
			'ekstra' => $this->ekstraModel->findAll(),
		]);
	}

	public function visi_misi()
	{
		return view('page/visimisi', [
			'title' =>  'Visi & Misi',
			'setting' => $this->settingModel->first(),
			'info' => $this->pengumumanModel->first(),
			'berita' => $this->artikelModel->orderBy('id', 'DESC')->findAll(3),
			'fasilitas' => $this->fasilitasModel->findAll(),
			'ekstra' => $this->ekstraModel->findAll(),
		]);
	}

	public function kirim_pesan()
	{
		$rules = [
			'nama' => [
				'rules'  => 'required',
				'errors' => []
			],
			'email' => [
				'rules'  => 'required',
				'errors' => []
			],
			'pesan' => [
				'rules'  => 'required',
				'errors' => []
			],
		];

		$data = [
			'nama' => $this->request->getPost('nama'),
			'email' => $this->request->getPost('email'),
			'isi' => $this->request->getPost('pesan'),
		];

		if (!$this->validate($rules)) {
			//render view with error validation message
			return $this->index();
		} else {
			$this->kontakModel->save($data);
			$this->session->setFlashdata('success', 'Pesan sudah kami terima, Silahkan Tunggu Balasan Melalui Email Anda!.');
			return redirect()->to('/');
		}
	}
}
