<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use \App\Models\UserModel;

class Users extends BaseController
{
	protected $userModel;

	public function __construct()
	{
		$this->userModel = new UserModel();
	}

	public function index()
	{
		if ($this->session->logged_in == true && $this->session->roles == 2) {
			return redirect()->to('/admin/dashboard');
		}

		return view('admin/users/index', [
			'title' => 'Users',
			'users' => $this->userModel->findAll(),
		]);
	}

	public function new()
	{
		return view('admin/users/create', [
			'title' => 'Tambah Data User',
			'validation' => $this->validation,
		]);
	}

	public function create()
	{
		$rules = [
			'email' => [
				'rules'  => 'required|valid_email|is_unique[users.email]',
				'errors' => []
			],
			'username' => [
				'rules'  => 'required|is_unique[users.username]',
				'errors' => []
			],
			'password' => [
				'rules'  => 'required',
				'errors' => []
			],
			'nama' => [
				'rules'  => 'required',
				'errors' => []
			],
			'roles' => [
				'rules'  => 'required',
				'errors' => []
			],
		];

		$data = [
			'email' => $this->request->getPost('email'),
			'username' => $this->request->getPost('username'),
			'password' => password_hash($this->request->getPost('password'), PASSWORD_BCRYPT),
			'nama' => $this->request->getPost('nama'),
			'roles' => $this->request->getPost('roles'),
		];

		if (!$this->validate($rules)) {
			//render view with error validation message
			return redirect()->back()->withInput();
		} else {
			$this->userModel->save($data);
			$this->session->setFlashdata('success', 'Data User Berhasil Ditambahkan.');
			return redirect()->to('/admin/users');
		}
	}

	public function edit($id)
	{
		return view('admin/users/edit', [
			'title' => 'Edit Data User',
			'user' => $this->userModel->find($id),
			'validation' => $this->validation,
		]);
	}

	public function update($id)
	{
		$rules = [
			'email' => [
				'rules'  => 'required|valid_email',
				'errors' => []
			],
			'username' => [
				'rules'  => 'required',
				'errors' => []
			],
			'nama' => [
				'rules'  => 'required',
				'errors' => []
			],
			'roles' => [
				'rules'  => 'required',
				'errors' => []
			],
		];

		if ($this->request->getPost('password') != '') {
			$password = password_hash($this->request->getPost('password'), PASSWORD_BCRYPT);
			$data = [
				'email' => $this->request->getPost('email'),
				'username' => $this->request->getPost('username'),
				'password' => $password,
				'nama' => $this->request->getPost('nama'),
				'roles' => $this->request->getPost('roles'),
			];
		} else {
			$data = [
				'email' => $this->request->getPost('email'),
				'username' => $this->request->getPost('username'),
				'nama' => $this->request->getPost('nama'),
				'roles' => $this->request->getPost('roles'),
			];
		}

		if (!$this->validate($rules)) {
			//render view with error validation message
			return redirect()->back()->withInput();
		} else {
			$this->userModel->update($id, $data);
			$this->session->setFlashdata('success', 'Data User Berhasil Diubah.');
			return redirect()->to('/admin/users');
		}
	}

	public function delete($id)
	{
		if ($id == 1) {
			$this->session->setFlashdata('error', 'Something went wrong!');
			return redirect()->to('/admin/users');
		} else {
			$this->userModel->delete($id);
			$this->session->setFlashdata('success', 'Data User Berhasil Dihapus.');
			return redirect()->to('/admin/users');
		}
	}
}
