<?= $this->extend('layouts/theme-frontend') ?>
<?= $this->section('content-frontend') ?>

<div class="jumbotron-fluid p-10 bg-primary">
   <div class="row">
      <div class="col-md-12">
         <h1 class="text-center display-4 text-white">Pengumuman</h1>
         <h4 class="text-center"></h4>
      </div>
   </div>
</div>

<div class="container my-5">
   <?php if (!empty($pengumuman)) { ?>
      <div class="postList mb-4">
         <?php foreach ($pengumuman as $row) { ?>
            <?php $postID = $row['id']; ?>
            <div class="list_item pb-4">
               <div class="card">
                  <img src="<?= base_url('img/pengumuman/' . $row['foto_pengumuman']) ?>" class="card-img-top" alt="">
                  <div class="card-body">
                     <a href="<?= base_url('pengumuman/' . $row['id']); ?>" class="h3 mb-4" alt="">
                        <?= $row['judul_pengumuman']; ?>
                     </a><br />
                     <i class="fa-regular fa-calendar"></i> <?= date('d-m-Y', strtotime($row['created_at'])); ?> - <span><i class="fa-regular fa-user"></i> Admin</span>
                     <?php
                     $string = $row['isi_pengumuman'];
                     $isi = (strlen($string) > 13) ? substr($string, 0, 180) . '...' : $string;
                     ?>
                     <p class="card-text"><?= $isi; ?></p>
                  </div>
               </div>
            </div>
         <?php } ?>
         <div class="show_more_main" id="show_more_main<?= $postID; ?>">
            <input type="hidden" name="<?= csrf_token() ?>" value="<?= csrf_hash() ?>" id="csrfSecure" />
            <span id="<?= $postID; ?>" class="show_more" title="Load more posts">Lihat lainnya</span>
            <span class="loading" style="display: none;">
               <i class="fa fa-circle-notch fa-spin"></i> <span class="loading_txt">Loading...</span>
            </span>
         </div>
      </div>
   <?php } else { ?>
      <div class="text-center">
         Tidak ada data Pengumuman
      </div>
   <?php } ?>
</div>

<?= $this->endSection() ?>

<?= $this->section('script') ?>
<script>
   var baseUrl = '<?= base_url(); ?>';

   $(document).ready(function() {
      $(document).on('click', '.show_more', function() {
         var ID = $(this).attr('id');
         var csrfName = '<?= csrf_token() ?>'; // Value specified in $config
         var csrfHash = $('input[name=<?= csrf_token() ?>]').val(); // CSRF hash
         $('.show_more').hide();
         $('.loading').show();
         $.ajax({
            type: 'POST',
            url: baseUrl + '/pengumuman/loadmore',
            data: {
               id: ID,
               [csrfName]: csrfHash
            },
            success: function(html) {
               $('#show_more_main' + ID).remove();
               $('.postList').append(html);
            }
         });
      });
   })
</script>
<?= $this->endSection() ?>