<?php

use \App\Models\PengaturanwebModel;

$pengaturan = new PengaturanwebModel;
$infoSekolah = $pengaturan->first();

$namaSekolah   = $infoSekolah['nama_website'];
$logoSekolah   = $infoSekolah['logo_sekolah'];
$alamatSekolah = $infoSekolah['alamat'];
$emailSekolah  = $infoSekolah['email'];
$noTelp        = $infoSekolah['no_telp'];
$noWhatsapp    = $infoSekolah['no_whatsapp'];
$colorNavbar   = $infoSekolah['bgcolor_navbar'];
$textNavbar    = $infoSekolah['txcolor_navbar'];
$colorFooter   = $infoSekolah['bgcolor_footer'];
?>
<!doctype html>
<html lang="id">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= $namaSekolah; ?> | <?= $title ?? '' ?></title>
  <meta name="description" content="Website Sekolah <?= $namaSekolah; ?>" />
  <meta name="robots" content="index, follow">

  <link rel="shortcut icon" href="<?= base_url('img/pengaturan/' . $logoSekolah) ?>" type="image/x-icon">

  <!-- Bootstrap & Custom CSS -->
  <link rel="stylesheet" href="<?= base_url('template/assets/css/plugins.css') ?>">
  <link rel="stylesheet" href="<?= base_url('template/assets/css/style.css') ?>">
  <link rel="stylesheet" href="<?= base_url('frontend/css/style.css') ?>">

  <!-- Icons & DataTables -->
  <link href="<?= base_url('frontend/vendor/fontawesome/css/all.min.css') ?>" rel="stylesheet">
  <link rel="stylesheet" href="<?= base_url('frontend/vendor/datatables/css/dataTables.bootstrap5.min.css') ?>">
</head>

<body>
  <div class="content-wrapper">
    <!-- Header -->
    <header class="wrapper bg-light mb-3">
      <div class="bg-dark text-white fw-bold fs-15 mb-2">
        <div class="container py-2 d-md-flex flex-md-row">
          <div class="d-flex flex-row align-items-center">
            <i class="uil uil-location-pin-alt me-2"></i>
            <address class="mb-0"><?= $alamatSekolah; ?></address>
          </div>
          <div class="d-flex flex-row align-items-center me-6 ms-auto">
            <i class="uil uil-phone-volume me-2"></i>
            <p class="mb-0"><?= $noTelp; ?></p>
          </div>
          <div class="d-flex flex-row align-items-center">
            <i class="uil uil-message me-2"></i>
            <p class="mb-0">
              <a href="mailto:<?= $emailSekolah; ?>" class="link-white"><?= $emailSekolah; ?></a>
            </p>
          </div>
        </div>
      </div>

      <!-- Navbar -->
      <nav class="navbar navbar-expand-lg center-nav transparent navbar-light" style="background-color: <?= $colorNavbar; ?>;color: <?= $textNavbar; ?>;">
        <div class="container flex-lg-row flex-nowrap align-items-center">
          <div class="navbar-brand w-100">
            <a href="<?= base_url(); ?>">
              <img src="<?= base_url('img/pengaturan/' . $logoSekolah) ?>" width="55" alt="Logo" />
              <span class="h5"><?= $namaSekolah; ?></span>
            </a>
          </div>

          <div class="navbar-collapse offcanvas offcanvas-nav offcanvas-start">
            <div class="offcanvas-header d-lg-none">
              <h3 class="text-white fs-30 mb-0"><?= $namaSekolah; ?></h3>
              <button type="button" class="btn-close btn-close-white" data-bs-dismiss="offcanvas"></button>
            </div>
            <div class="offcanvas-body ms-lg-auto d-flex flex-column h-100">
              <ul class="navbar-nav">
                <li class="nav-item dropdown pe-3">
                  <a class="nav-link dropdown-toggle" href="#" data-bs-toggle="dropdown">Tentang Kami</a>
                  <div class="dropdown-menu">
                    <a class="dropdown-item" href="<?= base_url('sambutan-kepala-sekolah') ?>">Sambutan Kepala Sekolah</a>
                    <a class="dropdown-item" href="<?= base_url('struktur-organisasi') ?>">Struktur Organisasi</a>
                    <a class="dropdown-item" href="<?= base_url('visi-misi') ?>">Visi & Misi</a>
                    <a class="dropdown-item" href="<?= base_url('guru-staf') ?>">Guru & Staf</a>
                    <a class="dropdown-item" href="<?= base_url('fasilitas') ?>">Fasilitas Sekolah</a>
                    <a class="dropdown-item" href="<?= base_url('ekstrakurikuler') ?>">Ekstrakurikuler</a>
                  </div>
                </li>
                <li><a href="<?= base_url('berita') ?>" class="nav-link pe-3">Berita</a></li>
                <li><a href="<?= base_url('pengumuman') ?>" class="nav-link pe-3">Pengumuman</a></li>
                <li><a href="<?= base_url('galeri') ?>" class="nav-link pe-3">Galeri</a></li>
                <li><a href="<?= base_url('#kontak') ?>" class="nav-link pe-3">Kontak</a></li>
              </ul>

              <div class="offcanvas-footer d-lg-none">
                <div>
                  <a href="mailto:<?= $emailSekolah; ?>" class="link-inverse"><?= $emailSekolah; ?></a><br />
                  <?= $noTelp; ?>
                </div>
              </div>
            </div>
          </div>

          <!-- Right buttons -->
          <div class="navbar-other w-100 d-flex ms-auto">
            <ul class="navbar-nav flex-row align-items-center ms-auto">
              <li class="nav-item d-none d-md-block">
                <a class="btn btn-sm btn-primary me-2" href="<?= base_url('ppdb') ?>">Pendaftaran</a>
                <?php if (session()->get('id')) : ?>
                  <a class="btn btn-sm btn-primary" href="<?= base_url('admin/dashboard'); ?>"><i class="fas fa-tachometer-alt"></i> Dashboard</a>
                <?php else : ?>
                  <a class="btn btn-sm btn-primary" href="<?= base_url('login'); ?>"><i class="fas fa-sign-in"></i> Login</a>
                <?php endif; ?>
              </li>
              <li class="nav-item d-lg-none">
                <button class="hamburger offcanvas-nav-btn"><span></span></button>
              </li>
            </ul>
          </div>
        </div>
      </nav>
    </header>

    <!-- Main Content -->
    <?= $this->renderSection('content-frontend') ?>
  </div>

  <!-- Footer -->
  <footer style="background-color: <?= $colorFooter; ?>;color:#fff !important;">
    <div class="container py-10 py-md-10">
      <div class="top mb-5">
        <div class="logo-details">
          <img src="<?= base_url('img/pengaturan/' . $logoSekolah) ?>" width="55" height="55" alt="">
          <span class="h2 text-white"><?= $namaSekolah; ?></span>
        </div>
      </div>
      <div class="row link-boxes">
        <div class="col-md-3">
          <h4 class="widget-title mb-3 text-white">Kontak</h4>
          <ul class="list-unstyled text-reset mb-0">
            <li><?= $alamatSekolah; ?></li>
            <li>Email: <a href="mailto:<?= $emailSekolah; ?>" class="text-white"><?= $emailSekolah; ?></a></li>
            <li>Telp: <a href="tel:<?= $noTelp; ?>" class="text-white"><?= $noTelp; ?></a></li>
            <li>WhatsApp: <a href="https://wa.me/<?= $noWhatsapp; ?>" class="text-white"><?= $noWhatsapp; ?></a></li>
          </ul>
        </div>
        <div class="col-md-3">
          <h4 class="widget-title mb-3 text-white">Berita</h4>
          <ul class="list-unstyled text-reset mb-0">
            <?php foreach ($berita as $b) : ?>
              <li><a href="<?= base_url('berita/' . $b['id']) ?>" class="text-white"><?= $b['judul'] ?></a></li>
            <?php endforeach; ?>
          </ul>
        </div>
        <div class="col-md-3">
          <h4 class="widget-title mb-3 text-white">Fasilitas</h4>
          <ul class="list-unstyled text-reset mb-0">
            <?php foreach ($fasilitas as $f) : ?>
              <li><a href="#" class="text-white"><?= $f['fasilitas'] ?></a></li>
            <?php endforeach; ?>
          </ul>
        </div>
      </div>

      <div class="col-md-12 py-5">
        <div class="text-center">
          <span class="copyright_text">Copyright © <?= date('Y'); ?>
            <a href="<?= base_url(); ?>" class="text-white"><?= $namaSekolah; ?></a>
          </span>
        </div>
      </div>
    </div>
  </footer>

  <!-- Scripts -->
  <script src="<?= base_url('frontend/js/jquery-3.6.0.min.js') ?>"></script>
  <script src="<?= base_url('template/assets/js/plugins.js') ?>"></script>
  <script src="<?= base_url('template/assets/js/theme.js') ?>"></script>
  <script src="<?= base_url('frontend/vendor/sweetalert2/dist/sweetalert2.all.min.js') ?>"></script>
  <script src="<?= base_url('frontend/vendor/datatables/js/jquery.dataTables.min.js') ?>"></script>
  <script src="<?= base_url('frontend/vendor/datatables/js/dataTables.bootstrap5.min.js') ?>"></script>

  <?= $this->renderSection('script'); ?>

  <script>
    // Lazy load image
    window.addEventListener('load', function() {
      setTimeout(lazyLoad, 1000);
    });
    function lazyLoad() {
      document.querySelectorAll('.card-image').forEach(function(card_image) {
        let image_url = card_image.getAttribute('data-image-full');
        let content_image = card_image.querySelector('img');
        content_image.src = image_url;
        content_image.addEventListener('load', function() {
          card_image.style.backgroundImage = 'url(' + image_url + ')';
          card_image.classList.add('is-loaded');
        });
      });
    }

    // Sweetalert success flashdata
    <?php if (session()->getFlashdata('success')) : ?>
      Swal.fire('Terima Kasih!', '<?= session()->getFlashdata('success'); ?>', 'success');
    <?php endif; ?>
  </script>
</body>
</html>
