<?php

use \App\Models\PengaturanwebModel;

$pengaturan = new PengaturanwebModel;
$infoSekolah = $pengaturan->first();
$namaSekolah = $infoSekolah['nama_website'];
$logoSekolah = $infoSekolah['logo_sekolah'];
$alamatSekolah = $infoSekolah['alamat'];
$emailSekolah = $infoSekolah['email'];
$noTelp = $infoSekolah['no_telp'];
$noWhatsapp = $infoSekolah['no_whatsapp'];
$colorNavbar =  $infoSekolah['bgcolor_navbar'];
$textNavbar = $infoSekolah['txcolor_navbar'];
$colorFooter =  $infoSekolah['bgcolor_footer'];
?>
<?= $this->extend('layouts/theme-frontend') ?>
<?= $this->section('content-frontend') ?>
<!-- Home Carousel Slideshow -->
<section class="wrapper bg-light">
  <div class="container-card">
    <div class="card image-wrapper bg-full bg-image mt-2 mb-0" data-image-src="<?= base_url('img/1706252096_1375e0828948ddb4453d.jpg'); ?>">
      <div id="carousel" class="carousel slide" data-bs-ride="carousel">
        <div class="carousel-indicators py-3">
          <?php
          for ($i = 0; $i < count($slideshow); $i++) {
            echo '<button data-bs-target="#carousel" data-bs-slide-to="' . $i . '"';
            if ($i == 0) {
              echo 'class="active"';
            }
            echo '></button>';
          } ?>
        </div>
        <div class="carousel-inner">
          <div class="container">
            <?php
            $i = 0;
            foreach ($slideshow as $gallery) {
              $i++;
            ?>
              <div class="carousel-item <?= ($i == 1 ? 'active' : ''); ?> py-10 px-0">
                <div class="row gx-md-8 gx-xl-12 gy-10 align-items-center text-center text-lg-start">
                  <div class="col-lg-7" data-cues="slideInDown" data-group="page-title" data-delay="900">
                    <div class="container">
                      <h1 class="display-4 mb-4 me-xl-5 me-xxl-0 text-warning"><?= $gallery['judul_slide'] ?></h1>
                      <p class="lead fs-23 lh-sm mb-7 pe-xxl-15 text-white"><?= $gallery['deskripsi_slide'] ?></p>
                    </div>
                  </div>
                  <div class="col-lg-5">
                    <img class="img-fluid rounded img-thumbnail shadow-black" src="<?= base_url('img/slideshow/' . $gallery['foto_slide']); ?>" height="540" alt="<?= $gallery['judul_slide'] ?>">
                  </div>
                </div>
              </div>
            <?php
            }
            ?>
          </div>
          <button class="carousel-control-prev" type="button" data-bs-target="#carousel" data-bs-slide="prev">
            <span class="carousel-control-prev-icon" aria-hidden="true"></span>
            <span class="visually-hidden">Previous</span>
          </button>
          <button class="carousel-control-next" type="button" data-bs-target="#carousel" data-bs-slide="next">
            <span class="carousel-control-next-icon" aria-hidden="true"></span>
            <span class="visually-hidden">Next</span>
          </button>
        </div>
      </div>
    </div>
  </div>
</section>

<!-- Kata Pengatar Kepala Sekolah -->
<div class="container">
  <div class="row">
    <div class="col-md-12 text-center mt-10 mb-3">
      <h2 class="fs-15 text-uppercase text-muted mb-3">Selamat Datang</h2>
      <h3 class="display-4"><?= $namaSekolah; ?></h3>
    </div>
  </div>
  <div class="row">
    <div class="col-md-4">
      <div class="card">
        <img class="card-img-top" src="<?= base_url('img/kepsek/' . $kepsek['foto_kepsek']) ?>" alt="" />
        <a class="card-body" href="#" target="_blank">
          <h2><?= $kepsek['nama_kepsek'] ?></h2>
          <p>Kepala Sekolah</p>
        </a>
      </div>
    </div>
    <div class="col-md-8 shadow-lg p-3 mb-5 bg-white rounded">
      <p><?= $kepsek['kata_sambutan'] ?></p>
    </div>
  </div>
</div>

<!-- Fasilitas -->
<div class="container-fluid">
  <div class="row">
    <div class="col-md-12 text-center mt-4 mb-3">
      <a href="<?= base_url('fasilitas'); ?>" class="text-dark" title="Fasilitas" alt="Fasilitas">
        <h2 class="fs-15 text-uppercase text-muted mb-3"></h2>
        <h3 class="display-4">Fasilitas</h3>
      </a>
    </div>
  </div>
  <div class="row">
    <?php foreach ($fasilitaslimit3 as $f3) : ?>
      <div class="col-md-4">
        <div class="card">
          <img src="<?= base_url('img/fasilitas/' . $f3['foto_fasilitas']) ?>" class="card-img-top" height="200" alt="<?= $f3['fasilitas'] ?>">
          <div class="card-body">
            <h5 class="card-title"><?= $f3['fasilitas'] ?></h5>
            <p class="card-text"><?= $f3['deskripsi'] ?></p>
          </div>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
</div>

<!-- Berita -->
<div class="container-fluid">
  <div class="row">
    <div class="col-md-12 text-center mt-4 mb-3">
      <h2 class="fs-15 text-uppercase text-muted mb-3"></h2>
      <h3 class="display-4">Berita</h3>
    </div>
  </div>
  <?php if (!empty($artikel)) { ?>
    <div class="postList row">
      <?php foreach ($artikel as $berita) { ?>
        <?php $postID = $berita['id']; ?>
        <div class="col-md-4 list_item">
          <div class="card">
            <img src="<?= base_url('img/artikel/' . $berita['foto_artikel']) ?>" class="card-img-top" alt="" width="100%" height="200">
            <div class="card-body">
              <i class="fa-regular fa-calendar"></i> <?= date('d-m-Y', strtotime($berita['created_at'])); ?> - <span><i class="fa-regular fa-user"></i> Admin</span><br />
              <h5 class="card-title"><a href="<?= base_url('berita/' . $berita['id']) ?>"><?= $berita['judul'] ?></a></h5>
              <?php
              $string = $berita['isi'];
              $isi = (strlen($string) > 13) ? substr($string, 0, 60) . '...' : $string;
              ?>
              <p class="card-text"><?= $isi; ?></p>
            </div>
          </div>
        </div>
      <?php } ?>
      <div class="show_more_main" id="show_more_main<?= $postID; ?>">
        <input type="hidden" name="<?= csrf_token() ?>" value="<?= csrf_hash() ?>" id="csrfSecure" />
        <span id="<?= $postID; ?>" class="show_more" title="Load more posts">Lihat lainnya</span>
        <span class="loading" style="display: none;"><i class="fa fa-circle-notch fa-spin"></i> <span class="loading_txt">Loading...</span></span>
      </div>
    </div>
  <?php } else { ?>
    <div class="text-center">
      Tidak ada data Artikel
    </div>
  <?php } ?>

</div>

<!-- Daftar Sekolah -->
<div class="p-5 mb-4 bg-dark mt-5" style="background-image: url('<?= base_url('frontend/img/bg_1.jpg'); ?>') !important;background-position: center;background-repeat: no-repeat;-webkit-background-size: cover;-moz-background-size: cover;-o-background-size: cover;background-size: cover;">
  <div class="container-fluid my-5 py-5">
    <h1 class="display-5 fw-bold text-light">AYO DAFTAR SEKARANG!</h1>
    <!--<p class="col-md-8 fs-4 text-light">Bergabunglah dengan kami dan raih masa depan yang gemilang!</p>-->
    <a href="<?= base_url('ppdb') ?>" class="btn btn-warning btn-lg shadow rounded"><i class="fa-solid fa-up-right-from-square"></i>&nbsp;Daftar Sekarang</a>
  </div>
</div>

<!-- Kontak -->
<section id="kontak">
  <div class="container">
    <div class="row mt-5">
      <div class="col-md-12 p-3">
        <div class="text-center mb-4">
          <h2 class="fs-15 text-uppercase text-muted mb-3"></h2>
          <h3 class="display-4">Kontak</h3>
          <h3 class="display-6 mb-10">Ada Pertanyaan? Hubungi Kami</h3>
        </div>
        <div class="row">
          <div class="col-md-6">
            <h5>Form Kontak</h5>
            <?= form_open('kirim_pesan') ?>
            <div class="mb-3">
              <input type="text" name="nama" placeholder="Nama Lengkap" class="form-control form-control-lg <?= ($validation->hasError('nama') ? "is-invalid" : "") ?>">
              <div class="invalid-feedback">
                <?= $validation->getError('nama') ?>
              </div>
            </div>
            <div class="mb-3">
              <input type="email" name="email" placeholder="Email Address" class="form-control form-control-lg <?= ($validation->hasError('email') ? "is-invalid" : "") ?>">
              <div class="invalid-feedback">
                <?= $validation->getError('email') ?>
              </div>
            </div>
            <div class="mb-3">
              <textarea name="pesan" id="pesan" class="form-control form-control-lg <?= ($validation->hasError('pesan') ? "is-invalid" : "") ?>" placeholder="Pesan Anda..."></textarea>
              <div class="invalid-feedback">
                <?= $validation->getError('pesan') ?>
              </div>
            </div>
            <div class="mb-3">
              <button type="submit" id="kirim" class="btn btn-warning btn-lg"><i class="fa-solid fa-paper-plane"></i>&nbsp; Kirim</button>
            </div>
            <?= form_close(); ?>
          </div>
          <div class="col-md-6">
            <h5>Lokasi Sekolah</h5>
            <?= $setting['gmaps'] ?>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

<?= $this->endSection() ?>

<?= $this->section('script') ?>
<script>
  var baseUrl = '<?= base_url(); ?>';

  $(document).ready(function() {
    $(document).on('click', '.show_more', function() {
      var ID = $(this).attr('id');
      var csrfName = '<?= csrf_token() ?>'; // Value specified in $config
      var csrfHash = $('input[name=<?= csrf_token() ?>]').val(); // CSRF hash
      $('.show_more').hide();
      $('.loading').show();
      $.ajax({
        type: 'POST',
        url: baseUrl + '/home/loadmore',
        data: {
          id: ID,
          [csrfName]: csrfHash
        },
        success: function(html) {
          $('#show_more_main' + ID).remove();
          $('.postList').append(html);
        }
      });
    });
  })
</script>
<?= $this->endSection() ?>