<?= $this->extend('layouts/theme-backend') ?>

<?= $this->section('content') ?>
<h1 class="h2 mb-3 text-gray-900">Edit Galeri <?= $galeri['nama_galeri']; ?></h1>

<div id="content">
   <div class="card shadow mb-4">
      <div class="card-body">
         <div class="row">
            <div class="col-md-6">
               <?= form_open_multipart('/admin/galeri/update/' . $galeri['id']) ?>
               <?= csrf_field(); ?>
               <input type="hidden" name="foto_galeri_lama" id="foto_galeri_lama" value="<?= $galeri['foto_galeri']; ?>">
               <div class="form-group">
                  <label for="nama_galeri">Nama Galeri</label>
                  <input type="text" name="nama_galeri" id="nama_galeri" class="form-control <?= (validation_show_error('nama_galeri') ? "is-invalid" : "") ?>" value="<?= $galeri['nama_galeri']; ?>">
                  <div class="invalid-feedback">
                     <?= validation_show_error('nama_galeri') ?>
                  </div>
               </div>
               <div class="form-group">
                  <label for="foto_galeri">Foto <small>(Format .jpg, .jpeg, .png)</small></label><br>
                  <img src="<?= base_url('img/galeri/' . $galeri['foto_galeri']) ?>" alt="" class="img-fluid mb-3">
                  <input type="file" name="foto_galeri" id="foto_galeri" class="form-control-file <?= (validation_show_error('foto_galeri') ? "is-invalid" : "") ?>" onchange="readFoto(event)">
                  <div class="invalid-feedback">
                     <?= validation_show_error('foto_galeri') ?>
                  </div>
                  <img id='output' class="mt-3 mb-0" style="width: 400px;">
               </div>
               <div class="form-group mt-4">
                  <button type="submit" class="btn btn-primary btn-lg">Update</button>
               </div>
               <?= form_close(); ?>
            </div>
         </div>
      </div>
   </div>
</div>
<?= $this->endSection() ?>