<?= $this->extend('layouts/theme-backend') ?>

<?= $this->section('content') ?>
<h1 class="h2 mb-3 text-gray-900">Edit Fasilitas <?= $fasilitas['fasilitas']; ?></h1>

<div id="content">
   <div class="card shadow mb-4">
      <div class="card-body">
         <div class="row">
            <div class="col-md-6">
               <?= form_open_multipart('/admin/fasilitas/update/' . $fasilitas['id']) ?>
               <?= csrf_field(); ?>
               <input type="hidden" name="foto_fasilitas_lama" id="foto_fasilitas_lama" value="<?= $fasilitas['foto_fasilitas']; ?>">
               <div class="form-group">
                  <label for="fasilitas">Fasilitas</label>
                  <input type="text" name="fasilitas" id="fasilitas" class="form-control <?= (validation_show_error('fasilitas') ? "is-invalid" : "") ?>" value="<?= $fasilitas['fasilitas']; ?>">
                  <div class="invalid-feedback">
                     <?= validation_show_error('fasilitas') ?>
                  </div>
               </div>
               <div class="form-group">
                  <label for="deskripsi">Deskripsi</label>
                  <textarea name="deskripsi" id="deskripsi" class="form-control <?= (validation_show_error('deskripsi') ? "is-invalid" : "") ?>"><?= $fasilitas['deskripsi']; ?></textarea>
                  <div class="invalid-feedback">
                     <?= validation_show_error('deskripsi') ?>
                  </div>
               </div>
               <div class="form-group">
                  <label for="foto_fasilitas">Foto <small>(Format .jpg, .jpeg, .png)</small></label><br>
                  <img src="<?= base_url('img/fasilitas/' . $fasilitas['foto_fasilitas']) ?>" alt="" class="img-fluid mb-3">
                  <input type="file" name="foto_fasilitas" id="foto_fasilitas" class="form-control-file <?= (validation_show_error('foto_fasilitas') ? "is-invalid" : "") ?>" onchange="readFoto(event)">
                  <div class="invalid-feedback">
                     <?= validation_show_error('foto_fasilitas') ?>
                  </div>
                  <img id='output' class="mt-3 mb-0" style="width: 400px;">
               </div>
               <div class="form-group mt-4">
                  <button type="submit" class="btn btn-primary btn-lg">Update</button>
               </div>
               <?= form_close(); ?>
            </div>
         </div>
      </div>
   </div>
</div>
<?= $this->endSection() ?>