<?= $this->extend('layouts/theme-backend') ?>

<?= $this->section('content') ?>
<h1 class="h2 mb-3 text-gray-900"><?= $title; ?></h1>

<!-- Content Row -->
<div class="row">
  <div class="col-xl-3 col-md-6 mb-4">
    <div class="card border-left-primary shadow h-100 py-2">
      <div class="card-body">
        <div class="row no-gutters align-items-center">
          <div class="col mr-2">
            <div class="text-sm font-weight-bold text-primary text-uppercase mb-1">
              Jumlah Guru</div>
            <div class="h2 mb-0 font-weight-bold text-gray-800"><?= $jmlGuru; ?></div>
          </div>
          <div class="col-auto">
            <i class="fas fa-user-tie fa-2x text-gray-300"></i>
          </div>
        </div>
        <?php if (session()->roles == '1') : ?><a href="<?= base_url('admin/guru'); ?>" alt="">Lihat <i class="fas fa-angle-right"></i></a><?php endif; ?>
      </div>
    </div>
  </div>

  <div class="col-xl-3 col-md-6 mb-4">
    <div class="card border-left-success shadow h-100 py-2">
      <div class="card-body">
        <div class="row no-gutters align-items-center">
          <div class="col mr-2">
            <div class="text-sm font-weight-bold text-success text-uppercase mb-1">
              Jumlah Siswa</div>
            <div class="h2 mb-0 font-weight-bold text-gray-800"><?= $jmlSiswa; ?></div>
          </div>
          <div class="col-auto">
            <i class="fas fa-users fa-2x text-gray-300"></i>
          </div>
        </div>
        <?php if (session()->roles == '1') : ?><a href="<?= base_url('admin/siswa'); ?>" alt="">Lihat <i class="fas fa-angle-right"></i></a><?php endif; ?>
      </div>
    </div>
  </div>

  <div class="col-xl-3 col-md-6 mb-4">
    <div class="card border-left-info shadow h-100 py-2">
      <div class="card-body">
        <div class="row no-gutters align-items-center">
          <div class="col mr-2">
            <div class="text-sm font-weight-bold text-info text-uppercase mb-1">Artikel Berita
            </div>
            <div class="row no-gutters align-items-center">
              <div class="col-auto">
                <div class="h2 mb-0 mr-3 font-weight-bold text-gray-800"><?= $jmlArtikel; ?></div>
              </div>
            </div>
          </div>
          <div class="col-auto">
            <i class="fas fa-clipboard-list fa-2x text-gray-300"></i>
          </div>
        </div>
        <?php if (session()->roles == '1') : ?><a href="<?= base_url('admin/artikel'); ?>" alt="">Lihat <i class="fas fa-angle-right"></i></a><?php endif; ?>
      </div>
    </div>
  </div>

  <div class="col-xl-3 col-md-6 mb-4">
    <div class="card border-left-warning shadow h-100 py-2">
      <div class="card-body">
        <div class="row no-gutters align-items-center">
          <div class="col mr-2">
            <div class="text-sm font-weight-bold text-warning text-uppercase mb-1">
              Kontak</div>
            <div class="h2 mb-0 font-weight-bold text-gray-800"><?= $jmlKontak; ?></div>
          </div>
          <div class="col-auto">
            <i class="fas fa-comments fa-2x text-gray-300"></i>
          </div>
        </div>
        <?php if (session()->roles == '1') : ?><a href="<?= base_url('admin/kontak'); ?>" alt="">Lihat <i class="fas fa-angle-right"></i></a><?php endif; ?>
      </div>
    </div>
  </div>
</div>
<!-- Content Row -->

<div class="jumbotron">
  <h1 class="display-4"><strong>Selamat Datang</strong></h1>
  <p class="lead">Website Sekolah <?= $setting['nama_website']; ?></p>
  <p>Visi: <?= $setting['visi']; ?></p>
  <p>Misi: <?= $setting['misi']; ?></p>
</div>
<?= $this->endSection() ?>