<?php

namespace App\Models;

use CodeIgniter\Model;

class ArtikelModel extends Model
{
	protected $DBGroup              = 'default';
    protected $table                = 'artikel';
    protected $primaryKey           = 'id';
    protected $useAutoIncrement     = true;
    protected $insertID             = 0;
    protected $returnType           = 'array';
    protected $useSoftDeletes       = false;
    protected $protectFields        = false;
    protected $allowedFields        = [];

    // Dates
    protected $useTimestamps        = true;
    protected $dateFormat           = 'datetime';
    protected $createdField         = 'created_at';
    protected $updatedField         = 'updated_at';
    protected $deletedField         = '';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks       = true;
    protected $beforeInsert         = [];
    protected $afterInsert          = [];
    protected $beforeUpdate         = [];
    protected $afterUpdate          = [];
    protected $beforeFind           = [];
    protected $afterFind            = [];
    protected $beforeDelete         = [];
    protected $afterDelete          = [];

    public function loadmoreArtikel($id = "", $limit = false)
    {
        $this->select("{$this->table}.*");
        if (!empty($id)) {
            $this->where("{$this->table}.id <", $id);
        }
        $this->orderBy("{$this->table}.id", "DESC");
        $query = $this->findAll($limit);
        return $query;
    }

    public function countLoadmoreArtikel($id = false)
    {
        $this->select("{$this->table}.*");
        $this->where("{$this->table}.id <", $id);
        $this->orderBy("{$this->table}.id", "DESC");
        $query = $this->countAllResults();
        return $query;
    }
}
