<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use \App\Models\SlideshowModel;

class Slideshow extends BaseController
{
	protected $slideshowModel;

	public function __construct()
	{
		$this->slideshowModel = new SlideshowModel();
	}

	public function index()
	{
		return view('admin/slideshow/index', [
			'title' => 'Home Slideshow',
			'slideshow' => $this->slideshowModel->findAll(),
		]);
	}

	public function new()
	{
		return view('admin/slideshow/create', [
			'title' => 'Tambah Gambar Slideshow',
			'validation' => $this->validation,
		]);
	}

	public function create()
	{
		$rules = [
			'judul_slide' => [
				'rules'  => 'required',
				'errors' => []
			],
			'foto_slide' => [
				'rules'  => 'uploaded[foto_slide]|mime_in[foto_slide,image/jpeg,image/pjpeg,image/png,image/x-png]|ext_in[foto_slide,jpg,jpeg,png]',
				'errors' => []
			],
			'status' => [
				'rules'  => 'required',
				'errors' => []
			],
		];

		if (!$this->validate($rules)) {
			//render view with error validation message
			return redirect()->back()->withInput();
		}

		$foto = $this->request->getFile('foto_slide');
		if ($foto->isValid()) {
			$name = $foto->getName();
			$newName = $foto->getRandomName();
			$foto->move('img/slideshow', $newName);
		}
		$data = [
			'judul_slide' => $this->request->getPost('judul_slide'),
			'deskripsi_slide' => $this->request->getPost('deskripsi_slide'),
			'foto_slide' => $newName,
			'status' => $this->request->getPost('status'),
		];

		$this->slideshowModel->insert($data);
		$this->session->setFlashdata('success', 'Data Slideshow Berhasil Ditambahkan.');
		return redirect()->to('/admin/slideshow');
	}

	public function edit($id)
	{
		return view('admin/slideshow/edit', [
			'title' => 'Edit Slideshow',
			'slideshow' => $this->slideshowModel->find($id),
			'validation' => $this->validation,
		]);
	}

	public function update($id)
	{
		$rules = [
			'judul_slide' => [
				'rules'  => 'required',
				'errors' => []
			],
			'foto_slide' => [
				'rules'  => 'mime_in[foto_slide,image/jpeg,image/pjpeg,image/png,image/x-png]|ext_in[foto_slide,jpg,jpeg,png]',
				'errors' => []
			],
			'status' => [
				'rules'  => 'required',
				'errors' => []
			],
		];

		if (!$this->validate($rules)) {
			//render view with error validation message
			return redirect()->back()->withInput();
		}

		$foto = $this->request->getFile('foto_slide');
		if ($foto->isValid()) {
			$name = $foto->getName();
			$newName = $foto->getRandomName();
			$foto->move('img/slideshow', $newName);
			unlink('img/slideshow/' . $this->request->getPost('foto_slide_lama'));
		} else {
			$newName = $this->request->getPost('foto_slide_lama');
		}

		$data = [
			'judul_slide' => $this->request->getPost('judul_slide'),
			'deskripsi_slide' => $this->request->getPost('deskripsi_slide'),
			'foto_slide' => $newName,
			'status' => $this->request->getPost('status'),
		];

		$this->slideshowModel->update($id, $data);
		$this->session->setFlashdata('success', 'Data Slideshow Berhasil Diubah.');
		return redirect()->to('/admin/slideshow');
	}

	public function delete($id)
	{
		$slideshow = $this->slideshowModel->find($id);
		unlink('img/slideshow/' . $slideshow['foto_slide']);
		$this->slideshowModel->delete($id);
		$this->session->setFlashdata('success', 'Data Slideshow Berhasil Dihapus.');
		return redirect()->to('/admin/slideshow');
	}

	public function active($id)
	{
		$data = [
			'status' => 1
		];

		$this->slideshowModel->update($id, $data);
		session()->setFlashdata('success', 'Gambar Slideshow Berhasil Diaktifkan.');
		return redirect()->to('/admin/slideshow');
	}
}
