<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\FasilitasModel;

class Fasilitas extends BaseController
{
    protected $fasilitasModel;
    protected $session;

    public function __construct()
    {
        $this->fasilitasModel = new FasilitasModel();
        $this->session        = session();
    }

    public function index()
    {
        $data = [
            'title'     => 'Data Fasilitas',
            'fasilitas' => $this->fasilitasModel->findAll()
        ];
        return view('admin/fasilitas/index', $data);
    }

    public function new()
    {
        $data = [
            'title' => 'Tambah Fasilitas'
        ];
        return view('admin/fasilitas/create', $data);
    }

    public function create()
    {
        $rules = [
            'fasilitas' => [
                'rules'  => 'required',
                'errors' => ['required' => 'Nama fasilitas harus diisi']
            ],
            'deskripsi' => [
                'rules'  => 'required',
                'errors' => ['required' => 'Deskripsi harus diisi']
            ],
            'foto_fasilitas' => [
                'rules'  => 'uploaded[foto_fasilitas]|mime_in[foto_fasilitas,image/jpeg,image/pjpeg,image/png]|ext_in[foto_fasilitas,jpg,jpeg,png]',
                'errors' => [
                    'uploaded' => 'Foto fasilitas wajib diupload',
                    'mime_in'  => 'Format foto tidak valid (hanya jpg, jpeg, png)',
                    'ext_in'   => 'Ekstensi foto tidak valid (hanya jpg, jpeg, png)'
                ]
            ],
        ];

        if (!$this->validate($rules)) {
            return redirect()->back()->withInput();
        }

        $foto    = $this->request->getFile('foto_fasilitas');
        $newName = 'default.jpg';

        if ($foto && $foto->isValid() && !$foto->hasMoved()) {
            $newName = $foto->getRandomName();
            $foto->move('img/fasilitas', $newName);
        }

        $data = [
            'fasilitas'      => $this->request->getPost('fasilitas'),
            'deskripsi'      => $this->request->getPost('deskripsi'),
            'foto_fasilitas' => $newName,
        ];

        $this->fasilitasModel->insert($data);
        $this->session->setFlashdata('success', 'Data fasilitas berhasil ditambahkan.');
        return redirect()->to('/admin/fasilitas');
    }

    public function edit($id)
    {
        $data = [
            'title'    => 'Edit Fasilitas',
            'fasilitas' => $this->fasilitasModel->find($id)
        ];
        return view('admin/fasilitas/edit', $data);
    }

	public function update($id)
	{
		$foto = $this->request->getFile('foto_fasilitas');
		$newName = $this->request->getPost('foto_fasilitas_lama'); // harus sama dengan hidden input di edit.php

		if ($foto && $foto->isValid() && !$foto->hasMoved()) {
			$newName = $foto->getRandomName();
			$foto->move('img/fasilitas', $newName);

			// hapus file lama kalau ada (dan bukan default)
			$oldFile = 'img/fasilitas/' . $this->request->getPost('foto_fasilitas_lama');
			if ($this->request->getPost('foto_fasilitas_lama') && $this->request->getPost('foto_fasilitas_lama') != 'default.jpg' && file_exists($oldFile)) {
				unlink($oldFile);
			}
		}

		$data = [
			'fasilitas'     => $this->request->getPost('fasilitas'),
			'deskripsi'     => $this->request->getPost('deskripsi'),
			'foto_fasilitas'=> $newName,
		];

		$this->fasilitasModel->update($id, $data);
		$this->session->setFlashdata('success', 'Data fasilitas berhasil diupdate.');
		return redirect()->to('/admin/fasilitas');
	}

    public function delete($id)
    {
        $fasilitas = $this->fasilitasModel->find($id);

        if ($fasilitas && $fasilitas['foto_fasilitas'] != 'default.jpg' && file_exists('img/fasilitas/' . $fasilitas['foto_fasilitas'])) {
            unlink('img/fasilitas/' . $fasilitas['foto_fasilitas']);
        }

        $this->fasilitasModel->delete($id);
        $this->session->setFlashdata('success', 'Data fasilitas berhasil dihapus.');
        return redirect()->to('/admin/fasilitas');
    }
}
