<?php

use \App\Models\PengaturanwebModel;

$pengaturan = new PengaturanwebModel;
$infoSekolah = $pengaturan->first();
$namaSekolah = $infoSekolah['nama_website'];
$logoSekolah = $infoSekolah['logo_sekolah'];
?>
<!DOCTYPE html>
<html lang="en">

<head>

    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title><?= $title; ?> | Web Sekolah</title>
    <meta name="description" content="Website Sekolah <?= $namaSekolah; ?>">
    <meta name="author" content="">
    <meta name="robots" content="noindex, nofollow">

    <link rel="shortcut icon" href="<?= base_url('img/pengaturan/' . $logoSekolah) ?>" type="image/x-icon">

    <!-- Custom fonts for this template-->
    <link href="<?= base_url(); ?>/assets/vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Nunito:200,200i,300,300i,400,400i,600,600i,700,700i,800,800i,900,900i" rel="stylesheet">

    <!-- Custom styles for this template-->
    <link href="<?= base_url(); ?>/assets/css/sb-admin-2.min.css" rel="stylesheet">
    <link href="<?= base_url(); ?>/assets/css/styles.css" rel="stylesheet">
    <script src="<?= base_url(); ?>/assets/vendor/ckeditor/ckeditor.js"></script>
    <link href="<?= base_url(); ?>/assets/vendor/datatables/dataTables.bootstrap4.min.css" rel="stylesheet" type="text/css">
</head>

<body id="page-top">

    <!-- Page Wrapper -->
    <div id="wrapper">

        <!-- Sidebar -->
        <ul class="navbar-nav bg-gradient-dark sidebar sidebar-dark accordion pt-2" id="accordionSidebar">
            <!-- Sidebar - Brand -->
            <a class="sidebar-brand d-flex align-items-center justify-content-center" href="<?= base_url('admin/dashboard') ?>">
                <div class="sidebar-brand-icon rotate-n-15">
                    <!--  <i class="fas fa-graduation-cap"></i> -->
                    <!-- <img src="<?= base_url('img/pengaturan/' . $infoSekolah['logo_sekolah']) ?>" alt=""> -->
                </div>
                <div class="mx-3"><?= $infoSekolah['nama_website']; ?></div>
            </a>

            <!-- Nav Item - Dashboard -->
            <li class="nav-item<?= (uri_string() == 'admin/dashboard' ? ' active' : ''); ?>">
                <a class="nav-link" href="<?= base_url('admin/dashboard') ?>">
                    <i class="fas fa-fw fa-tachometer-alt"></i>
                    <span>Dashboard</span></a>
            </li>

            <?php if (session()->roles == '1') { ?>
                <!-- Divider -->
                <hr class="sidebar-divider">

                <!-- Heading -->
                <div class="sidebar-heading">
                    Master Sekolah
                </div>

                <li class="nav-item">
                    <a class="nav-link" href="<?= base_url('admin/ppdb') ?>">
                        <i class="bi bi-people"></i><span>PPDB</span>
                    </a>
                </li>               

                <li class="nav-item<?= (uri_string() == 'admin/pengaturanweb' ? ' active' : ''); ?>">
                    <a class="nav-link" href="<?= base_url('admin/pengaturanweb') ?>">
                        <i class="fas fa-fw fa-cogs"></i>
                        <span>Pengaturan</span></a>
                </li>

                <li class="nav-item<?= (uri_string() == 'admin/tahunajaran' ? ' active' : ''); ?>">
                    <a class="nav-link" href="<?= base_url('admin/tahunajaran') ?>">
                        <i class="fas fa-fw fa-clipboard-list"></i>
                        <span>Tahun Ajaran</span></a>
                </li>

                <li class="nav-item<?= (uri_string() == 'admin/kepsek' ? ' active' : ''); ?>">
                    <a class="nav-link" href="<?= base_url('admin/kepsek') ?>">
                        <i class="fas fa-fw fa-user-graduate"></i>
                        <span>Kepsek</span></a>
                </li>

                <li class="nav-item<?= (uri_string() == 'admin/guru' ? ' active' : ''); ?>">
                    <a class="nav-link" href="<?= base_url('admin/guru') ?>">
                        <i class="fas fa-fw fa-users"></i>
                        <span>Guru</span></a>
                </li>

                <li class="nav-item<?= (uri_string() == 'admin/siswa' ? ' active' : ''); ?>">
                    <a class="nav-link" href="<?= base_url('admin/siswa') ?>">
                        <i class="fas fa-fw fa-book-reader"></i>
                        <span>Siswa</span></a>
                </li>

                <li class="nav-item<?= (uri_string() == 'admin/fasilitas' ? ' active' : ''); ?>">
                    <a class="nav-link" href="<?= base_url('admin/fasilitas') ?>">
                        <i class="fas fa-fw fa-archway"></i>
                        <span>Fasilitas</span></a>
                </li>

                <li class="nav-item<?= (uri_string() == 'admin/ekstrakurikuler' ? ' active' : ''); ?>">
                    <a class="nav-link" href="<?= base_url('admin/ekstrakurikuler') ?>">
                        <i class="fas fa-fw fa-boxes"></i>
                        <span>Ekstrakurikuler</span></a>
                </li>

                <li class="nav-item<?= (uri_string() == 'admin/artikel' ? ' active' : ''); ?>">
                    <a class="nav-link" href="<?= base_url('admin/artikel') ?>">
                        <i class="fas fa-fw fa-newspaper"></i>
                        <span>Berita</span></a>
                </li>

                <li class="nav-item<?= (uri_string() == 'admin/galeri' ? ' active' : ''); ?>">
                    <a class="nav-link" href="<?= base_url('admin/galeri') ?>">
                        <i class="fas fa-fw fa-th"></i>
                        <span>Galeri</span></a>
                </li>

                <li class="nav-item<?= (uri_string() == 'admin/pengumuman' ? ' active' : ''); ?>">
                    <a class="nav-link" href="<?= base_url('admin/pengumuman') ?>">
                        <i class="fas fa-fw fa-info-circle"></i>
                        <span>Pengumuman</span></a>
                </li>

                <li class="nav-item<?= (uri_string() == 'admin/kontak' ? ' active' : ''); ?>">
                    <a class="nav-link" href="<?= base_url('admin/kontak') ?>">
                        <i class="fas fa-fw fa-id-badge"></i>
                        <span>Kontak</span></a>
                </li>

                <li class="nav-item<?= (uri_string() == 'admin/slideshow' ? ' active' : ''); ?>">
                    <a class="nav-link" href="<?= base_url('admin/slideshow') ?>">
                        <i class="fas fa-fw fa-images"></i>
                        <span>Slideshow</span></a>
                </li>
                
                <!-- Nav Item - Pages Collapse Menu -->
                <!-- <li class="nav-item">
                <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#collapseTwo"
                    aria-expanded="true" aria-controls="collapseTwo">
                    <i class="fas fa-fw fa-cog"></i>
                    <span>Custom Data</span>
                </a>
                <div id="collapseTwo" class="collapse" aria-labelledby="headingTwo" data-parent="#accordionSidebar">
                    <div class="bg-white py-2 collapse-inner rounded">
                        <h6 class="collapse-header">Custom Components:</h6>
                        <a class="collapse-item" href="buttons.html">Buttons</a>
                        <a class="collapse-item" href="cards.html">Cards</a>
                    </div>
                </div>
            </li> -->

                <!-- Divider -->
                <hr class="sidebar-divider">

                <!-- Heading -->
                <div class="sidebar-heading">
                    Users
                </div>

                <li class="nav-item<?= (uri_string() == 'admin/users' ? ' active' : ''); ?>">
                    <a class="nav-link" href="<?= base_url('admin/users') ?>">
                        <i class="fas fa-fw fa-user"></i>
                        <span>Users</span></a>
                </li>
            <?php } else { ?>
                <!-- Divider -->
                <hr class="sidebar-divider">

                <!-- Heading -->
                <div class="sidebar-heading">
                    Master Sekolah
                </div>

                <li class="nav-item<?= (uri_string() == 'admin/guru' ? ' active' : ''); ?>">
                    <a class="nav-link" href="<?= base_url('admin/guru') ?>">
                        <i class="fas fa-fw fa-users"></i>
                        <span>Guru</span></a>
                </li>

                <li class="nav-item<?= (uri_string() == 'admin/siswa' ? ' active' : ''); ?>">
                    <a class="nav-link" href="<?= base_url('admin/siswa') ?>">
                        <i class="fas fa-fw fa-book-reader"></i>
                        <span>Siswa</span></a>
                </li>

                <li class="nav-item<?= (uri_string() == 'admin/artikel' ? ' active' : ''); ?>">
                    <a class="nav-link" href="<?= base_url('admin/artikel') ?>">
                        <i class="fas fa-fw fa-newspaper"></i>
                        <span>Berita</span></a>
                </li>

                <li class="nav-item<?= (uri_string() == 'admin/pengumuman' ? ' active' : ''); ?>">
                    <a class="nav-link" href="<?= base_url('admin/pengumuman') ?>">
                        <i class="fas fa-fw fa-info-circle"></i>
                        <span>Pengumuman</span></a>
                </li>

                <li class="nav-item<?= (uri_string() == 'admin/kontak' ? ' active' : ''); ?>">
                    <a class="nav-link" href="<?= base_url('admin/kontak') ?>">
                        <i class="fas fa-fw fa-id-badge"></i>
                        <span>Kontak</span></a>
                </li>
            <?php } ?>
            <!-- Divider -->
            <hr class="sidebar-divider d-none d-md-block">

            <!-- Sidebar Toggler (Sidebar) -->
            <div class="text-center d-none d-md-inline">
                <button class="rounded-circle border-0" id="sidebarToggle"></button>
            </div>

        </ul>
        <!-- End of Sidebar -->

        <!-- Content Wrapper -->
        <div id="content-wrapper" class="d-flex flex-column">

            <!-- Main Content -->
            <div id="content">

                <!-- Topbar -->
                <nav class="navbar navbar-expand navbar-light bg-white topbar mb-4 static-top shadow-sm navbar-fixed-top">
                    <!-- Sidebar Toggle (Topbar) -->
                    <button id="sidebarToggleTop" class="btn btn-outline-dark text-dark mr-3">
                        <i class="fa fa-bars"></i>
                    </button>

                    <ul class="navbar-nav">
                        <li class="nav-item">
                            <a class="nav-link text-dark" href="<?= base_url() ?>" title="Ke Website" alt="Ke Website" target="_blank">
                                <i class="fas fa-fw fa-globe"></i>
                            </a>
                        </li>
                    </ul>
                    <!-- Topbar Search -->
                    <!-- <form class="d-none d-sm-inline-block form-inline mr-auto ml-md-3 my-2 my-md-0 mw-100 navbar-search">
                        <div class="input-group">
                            <input type="text" class="form-control bg-light border-0 small" placeholder="Search for..." aria-label="Search" aria-describedby="basic-addon2">
                            <div class="input-group-append">
                                <button class="btn btn-primary" type="button">
                                    <i class="fas fa-search fa-sm"></i>
                                </button>
                            </div>
                        </div>
                    </form> -->

                    <!-- Topbar Navbar -->
                    <ul class="navbar-nav ml-auto">

                        <!-- Nav Item - Search Dropdown (Visible Only XS) -->
                        <li class="nav-item dropdown no-arrow d-sm-none">
                            <!-- <a class="nav-link dropdown-toggle" href="#" id="searchDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <i class="fas fa-search fa-fw"></i>
                            </a> -->
                            <!-- Dropdown - Messages -->
                            <div class="dropdown-menu dropdown-menu-right p-3 shadow animated--grow-in" aria-labelledby="searchDropdown">
                                <form class="form-inline mr-auto w-100 navbar-search">
                                    <div class="input-group">
                                        <input type="text" class="form-control bg-light border-0 small" placeholder="Search for..." aria-label="Search" aria-describedby="basic-addon2">
                                        <div class="input-group-append">
                                            <button class="btn btn-primary" type="button">
                                                <i class="fas fa-search fa-sm"></i>
                                            </button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </li>

                        <!-- <div class="topbar-divider d-none d-sm-block"></div> -->

                        <!-- Nav Item - User Information -->
                        <li class="nav-item dropdown no-arrow">
                            <a class="nav-link dropdown-toggle" href="#" id="userDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <img class="img-profile rounded-circle mr-2" src="<?= base_url('img/admin/admin.png'); ?>">
                                <span class="d-none d-lg-inline text-gray-600 small"><?= session()->nama; ?></span>
                            </a>
                            <!-- Dropdown - User Information -->
                            <div class="dropdown-menu dropdown-menu-right shadow animated--grow-in" aria-labelledby="userDropdown">
                                <a class="dropdown-item" href="#">
                                    <i class="fas fa-user fa-sm fa-fw mr-2 text-gray-400"></i>
                                    <?= session()->nama; ?>
                                    (<?= session()->email; ?>)
                                </a>
                                <!--<a class="dropdown-item" href="#">
                                    <i class="fas fa-cogs fa-sm fa-fw mr-2 text-gray-400"></i>
                                    Settings
                                </a>
                                <a class="dropdown-item" href="#">
                                    <i class="fas fa-list fa-sm fa-fw mr-2 text-gray-400"></i>
                                    Activity Log
                                </a> -->

                                <div class="dropdown-divider"></div>
                                <a class="dropdown-item" href="<?= base_url('auth/logout') ?>" data-toggle="modal" data-target="#logoutModal">
                                    <i class="fas fa-sign-out-alt fa-sm fa-fw mr-2 text-gray-400"></i>
                                    Logout
                                </a>
                            </div>
                        </li>

                    </ul>

                </nav>
                <!-- End of Topbar -->

                <!-- Begin Page Content -->
                <div class="container-fluid mt-3">
                    <?= $this->renderSection('content') ?>
                </div>
                <!-- /.container-fluid -->

            </div>
            <!-- End of Main Content -->

            <!-- Footer -->
            <footer class="sticky-footer bg-white">
                    <div class="text-center">
                        <span class="copyright_text">Copyright © <?= date('Y'); ?> <a href="<?= base_url(); ?>" class="text-blue"><?= $namaSekolah; ?></a></span>
                    </div>
            </footer>
            <!-- End of Footer -->

        </div>
        <!-- End of Content Wrapper -->

    </div>
    <!-- End of Page Wrapper -->

    <!-- Scroll to Top Button-->
    <a class="scroll-to-top rounded" href="#page-top">
        <i class="fas fa-angle-up"></i>
    </a>

    <!-- Logout Modal-->
    <div class="modal fade" id="logoutModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Ready to Leave?</h5>
                    <button class="close" type="button" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">Select "Logout" below if you are ready to end your current session.</div>
                <div class="modal-footer">
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Cancel</button>
                    <a class="btn btn-primary" href="<?= base_url('auth/logout') ?>">Logout</a>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap core JavaScript-->
    <script src="<?= base_url(); ?>/assets/vendor/jquery/jquery.min.js"></script>
    <script src="<?= base_url(); ?>/assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>

    <!-- Core plugin JavaScript-->
    <script src="<?= base_url(); ?>/assets/vendor/jquery-easing/jquery.easing.min.js"></script>

    <!-- Custom scripts for all pages-->
    <script src="<?= base_url(); ?>/assets/js/sb-admin-2.min.js"></script>
    <script src="<?= base_url(); ?>/assets/vendor/sweetalert2/dist/sweetalert2.all.min.js"></script>
    <script src="<?= base_url(); ?>/assets/vendor/datatables/jquery.dataTables.min.js"></script>
    <script src="<?= base_url(); ?>/assets/vendor/datatables/dataTables.bootstrap4.min.js"></script>
    <script>
        $('.alert').delay(5000).fadeOut('slow');
        CKEDITOR.replace('isi');
        CKEDITOR.replace('misi');
    </script>
    <?php if (!empty(session()->getFlashdata('success'))) : ?>
        <script>
            Swal.fire({
                title: 'Good job!',
                text: '<?= session()->getFlashdata('success'); ?>',
                icon: 'success',
            })
        </script>
    <?php endif; ?>
    <?php if (!empty(session()->getFlashdata('error'))) : ?>
        <script>
            Swal.fire({
                title: 'Oops..',
                text: '<?= session()->getFlashdata('error'); ?>',
                icon: 'error',
            })
        </script>
    <?php endif; ?>
    <script type="text/javascript">
        var readFoto = function(event) {
            var input = event.target;

            var reader = new FileReader();
            reader.onload = function() {
                var dataURL = reader.result;
                var output = document.getElementById('output');
                output.src = dataURL;
            };
            reader.readAsDataURL(input.files[0]);
        };
    </script>
    <?= $this->renderSection('script'); ?>
</body>

</html>