<?php

use \App\Models\PengaturanwebModel;

$pengaturan = new PengaturanwebModel;
$infoSekolah = $pengaturan->first();
$namaSekolah = $infoSekolah['nama_website'];
$logoSekolah = $infoSekolah['logo_sekolah'];
$visiSekolah = $infoSekolah['visi'];
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>Reset Password</title>
    <meta name="description" content="">
    <meta name="author" content="">

    <link rel="shortcut icon" href="<?= base_url('img/pengaturan/' . $logoSekolah) ?>" type="image/x-icon">

    <!-- Custom fonts for this template-->
    <link href="<?= base_url('assets/vendor/fontawesome-free/css/all.min.css') ?>" rel="stylesheet" type="text/css">
    <link href="https://fonts.googleapis.com/css?family=Lato:300,400,700,900&display=swap" rel="stylesheet">

    <!-- Custom styles for this template-->
    <link href="<?= base_url('template/assets/login/css/style.css') ?>" rel="stylesheet">
</head>

<body style="background-color: #66c2ff;">
    <section class="ftco-section">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-12 col-lg-10">
                    <div class="wrap d-md-flex">

                        <div class="text-wrap p-4 p-lg-5 text-center d-flex align-items-center order-md-last">
                            <div class="text w-100">
                                <p>
                                    <img src="<?= base_url('img/pengaturan/' . $logoSekolah) ?>" alt="" class="img img-thumbnail rounded-circle" style="max-height: 100px; width: auto;">
                                </p>
                                <h2><?= $namaSekolah; ?></h2>
                                <p><?= $visiSekolah; ?></p>
                            </div>
                        </div>

                        <div class="login-wrap p-4 p-lg-5">
                            <h1 class="h3 mb-3">Reset Password</h1>
                            <p class="text-muted mb-3">Verifikasi berhasil! Silakan buat password baru untuk akun Anda.</p>
                            
                            <!-- Detail User -->
                            <div class="card mb-4" style="border-left: 4px solid #28a745;">
                                <div class="card-body">
                                    <h6 class="card-title text-success"><i class="fas fa-user-check"></i> Detail Akun Terverifikasi</h6>
                                    <table class="table table-sm table-borderless mb-0">
                                        <tr>
                                            <td><strong>Username:</strong></td>
                                            <td><?= esc($user['username']); ?></td>
                                        </tr>
                                        <tr>
                                            <td><strong>Email:</strong></td>
                                            <td><?= esc($user['email']); ?></td>
                                        </tr>
                                        <tr>
                                            <td><strong>Nama:</strong></td>
                                            <td><?= esc($user['nama']); ?></td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                            
                            <hr />
                            
                            <?php if (session()->getFlashdata('danger') != null) : ?>
                                <div class="alert alert-danger">
                                    <span><?= session()->getFlashdata('danger'); ?></span>
                                </div>
                            <?php endif; ?>
                            <?php if (session()->getFlashdata('success') != null) : ?>
                                <div class="alert alert-success">
                                    <span><?= session()->getFlashdata('success'); ?></span>
                                </div>
                            <?php endif; ?>
                            
                            <?= form_open('auth/update-password'); ?>
                            <?= csrf_field(); ?>
                            
                            <div class="form-group mb-3">
                                <label class="label" for="password"><i class="fas fa-key"></i> Password Baru</label>
                                <input type="password" name="password" class="form-control form-control-lg <?= (validation_show_error('password') ? "is-invalid" : "") ?>" id="password" placeholder="Masukkan password baru...">
                                <div class="invalid-feedback">
                                    <?= validation_show_error('password') ?>
                                </div>
                                <small class="form-text text-muted">Password minimal 6 karakter</small>
                            </div>
                            
                            <div class="form-group mb-3">
                                <label class="label" for="confirm_password"><i class="fas fa-lock"></i> Konfirmasi Password</label>
                                <input type="password" name="confirm_password" class="form-control form-control-lg <?= (validation_show_error('confirm_password') ? "is-invalid" : "") ?>" id="confirm_password" placeholder="Ulangi password baru...">
                                <div class="invalid-feedback">
                                    <?= validation_show_error('confirm_password') ?>
                                </div>
                            </div>
                            
                            <div class="form-group form-check mb-3">
                                <input type="checkbox" id="showPassword" class="form-check-input" onclick="togglePassword()">
                                <label for="showPassword" class="form-check-label">Tampilkan password</label>
                            </div>
                            
                            <button type="submit" class="form-control btn btn-success submit px-3">
                                <i class="fas fa-save"></i> Simpan Password Baru
                            </button>
                            <?= form_close(); ?>
                            
                            <div class="text-center mt-3">
                                <a href="<?= base_url('login'); ?>" class="btn btn-link text-secondary">
                                    <i class="fas fa-arrow-left"></i> Kembali ke Login
                                </a>
                            </div>
                            
                            <hr />
                            <a href="<?= base_url(); ?>" alt="Home"><i class="fas fa-home"></i> Kembali ke Home</a>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </section>
    
    <!-- Bootstrap core JavaScript-->
    <script src="<?= base_url() ?>template/assets/login/js/jquery.min.js"></script>
	<script src="<?= base_url() ?>template/assets/login/js/popper.js"></script>
	<script src="<?= base_url() ?>template/assets/login/js/bootstrap.min.js"></script>
	<script src="<?= base_url() ?>template/assets/login/js/main.js"></script>

    <script>
        function togglePassword() {
            var password = document.getElementById("password");
            var confirmPassword = document.getElementById("confirm_password");
            
            if (password.type === "password") {
                password.type = "text";
                confirmPassword.type = "text";
            } else {
                password.type = "password";
                confirmPassword.type = "password";
            }
        }

        // Validasi real-time untuk konfirmasi password
        document.getElementById('confirm_password').addEventListener('input', function() {
            var password = document.getElementById('password').value;
            var confirmPassword = this.value;
            
            if (confirmPassword !== '' && password !== confirmPassword) {
                this.classList.add('is-invalid');
                this.classList.remove('is-valid');
            } else if (confirmPassword !== '' && password === confirmPassword) {
                this.classList.add('is-valid');
                this.classList.remove('is-invalid');
            } else {
                this.classList.remove('is-invalid', 'is-valid');
            }
        });
    </script>

</body>

</html>