<?= $this->extend('layouts/theme-backend') ?>
<?= $this->section('content') ?>

<div class="container-fluid">
  <div class="row">
    <div class="col-md-12">
      <div class="card">
        <div class="card-header bg-primary text-white">
          <h4 class="mb-0">Detail Pendaftar PPDB</h4>
        </div>
        <div class="card-body">
          <!-- Status dan Aksi -->
          <div class="row mb-4">
            <div class="col-md-6">
              <h6><strong>Status Pendaftaran:</strong></h6>
              <span class="badge bg-warning fs-6">Pending</span>
            </div>
            <div class="col-md-6 text-end">
              <div class="btn-group" role="group">
                <a href="<?= base_url('admin/ppdb/approve/'.$siswa['id']) ?>" 
                   onclick="return confirm('Terima pendaftar ini?')" 
                   class="btn btn-success">
                  <i class="fas fa-check"></i> Terima
                </a>
                <a href="<?= base_url('admin/ppdb/reject/'.$siswa['id']) ?>" 
                   onclick="return confirm('Tolak pendaftar ini?')" 
                   class="btn btn-danger">
                  <i class="fas fa-times"></i> Tolak
                </a>
                <a href="<?= base_url('admin/ppdb/edit/'.$siswa['id']) ?>" class="btn btn-warning">
                  <i class="fas fa-edit"></i> Edit
                </a>
                <a href="<?= base_url('admin/ppdb') ?>" class="btn btn-secondary">
                  <i class="fas fa-arrow-left"></i> Kembali
                </a>
              </div>
            </div>
          </div>

          <div class="row">
            <!-- Data Siswa -->
            <div class="col-md-6 mb-4">
              <div class="card">
                <div class="card-header bg-info text-white">
                  <h6 class="mb-0">Data Siswa</h6>
                </div>
                <div class="card-body">
                  <table class="table table-borderless">
                    <tr>
                      <td width="40%"><strong>Nama Lengkap:</strong></td>
                      <td><?= $siswa['nama_lengkap'] ?></td>
                    </tr>
                    <tr>
                      <td><strong>Nama Panggilan:</strong></td>
                      <td><?= $siswa['nama_panggilan'] ?? '-' ?></td>
                    </tr>
                    <tr>
                      <td><strong>Jenis Kelamin:</strong></td>
                      <td><?= $siswa['jenis_kelamin'] ?></td>
                    </tr>
                    <tr>
                      <td><strong>Tempat, Tgl Lahir:</strong></td>
                      <td><?= $siswa['tempat_tgl_lahir'] ?></td>
                    </tr>
                    <tr>
                      <td><strong>Agama:</strong></td>
                      <td><?= $siswa['agama'] ?></td>
                    </tr>
                    <tr>
                      <td><strong>Anak ke:</strong></td>
                      <td><?= $siswa['anak_nomor_ke'] ?? '-' ?> dari <?= $siswa['banyak_saudara'] ?? '-' ?> bersaudara</td>
                    </tr>
                    <tr>
                      <td><strong>Bahasa Sehari-hari:</strong></td>
                      <td><?= $siswa['bahasa_sehari'] ?? '-' ?></td>
                    </tr>
                    <tr>
                      <td><strong>Berat/Tinggi Badan:</strong></td>
                      <td><?= $siswa['berat_badan'] ?? '-' ?> kg / <?= $siswa['tinggi_badan'] ?? '-' ?> cm</td>
                    </tr>
                    <tr>
                      <td><strong>Umur Saat Daftar:</strong></td>
                      <td><?= $siswa['umur_saat_daftar'] ?? '-' ?> tahun</td>
                    </tr>
                  </table>
                </div>
              </div>
            </div>

            <!-- Data Orang Tua -->
            <div class="col-md-6 mb-4">
              <div class="card">
                <div class="card-header bg-success text-white">
                  <h6 class="mb-0">Data Orang Tua</h6>
                </div>
                <div class="card-body">
                  <table class="table table-borderless">
                    <tr>
                      <td width="40%"><strong>Nama Ayah:</strong></td>
                      <td><?= $siswa['nama_ayah'] ?></td>
                    </tr>
                    <tr>
                      <td><strong>Pendidikan Ayah:</strong></td>
                      <td><?= $siswa['pendidikan_ayah'] ?? '-' ?></td>
                    </tr>
                    <tr>
                      <td><strong>Pekerjaan Ayah:</strong></td>
                      <td><?= $siswa['pekerjaan_ayah'] ?? '-' ?></td>
                    </tr>
                    <tr>
                      <td><strong>Nama Ibu:</strong></td>
                      <td><?= $siswa['nama_ibu'] ?></td>
                    </tr>
                    <tr>
                      <td><strong>Pendidikan Ibu:</strong></td>
                      <td><?= $siswa['pendidikan_ibu'] ?? '-' ?></td>
                    </tr>
                    <tr>
                      <td><strong>Pekerjaan Ibu:</strong></td>
                      <td><?= $siswa['pekerjaan_ibu'] ?? '-' ?></td>
                    </tr>
                  </table>
                </div>
              </div>
            </div>

            <!-- Data Wali dan Kontak -->
            <div class="col-md-6 mb-4">
              <div class="card">
                <div class="card-header bg-warning text-dark">
                  <h6 class="mb-0">Data Wali & Kontak</h6>
                </div>
                <div class="card-body">
                  <table class="table table-borderless">
                    <tr>
                      <td width="40%"><strong>Nama Wali:</strong></td>
                      <td><?= $siswa['nama_wali'] ?? '-' ?></td>
                    </tr>
                    <tr>
                      <td><strong>Hubungan Wali:</strong></td>
                      <td><?= $siswa['hubungan_wali'] ?? '-' ?></td>
                    </tr>
                    <tr>
                      <td><strong>Pendidikan Wali:</strong></td>
                      <td><?= $siswa['pendidikan_wali'] ?? '-' ?></td>
                    </tr>
                    <tr>
                      <td><strong>Pekerjaan Wali:</strong></td>
                      <td><?= $siswa['pekerjaan_wali'] ?? '-' ?></td>
                    </tr>
                    <tr>
                      <td><strong>Alamat:</strong></td>
                      <td><?= $siswa['alamat_wali'] ?></td>
                    </tr>
                    <tr>
                      <td><strong>No HP/WhatsApp:</strong></td>
                      <td>
                        <?= $siswa['no_hp'] ?>
                        <a href="https://wa.me/<?= $siswa['no_hp'] ?>" target="_blank" class="btn btn-sm btn-success ms-2">
                          <i class="fab fa-whatsapp"></i> Chat
                        </a>
                      </td>
                    </tr>
                  </table>
                </div>
              </div>
            </div>

            <!-- Data Tambahan -->
            <div class="col-md-6 mb-4">
              <div class="card">
                <div class="card-header bg-secondary text-white">
                  <h6 class="mb-0">Data Tambahan</h6>
                </div>
                <div class="card-body">
                  <table class="table table-borderless">
                    <tr>
                      <td width="40%"><strong>Asal Mula:</strong></td>
                      <td><?= $siswa['asal_mula'] ?? '-' ?></td>
                    </tr>
                    <tr>
                      <td><strong>Tanggal Daftar:</strong></td>
                      <td><?= $siswa['tgl_daftar'] ?? '-' ?></td>
                    </tr>
                    <tr>
                      <td><strong>Tanggal Dibuat:</strong></td>
                      <td><?= date('d F Y, H:i', strtotime($siswa['created_at'])) ?> WIB</td>
                    </tr>
                    <tr>
                      <td><strong>Terakhir Update:</strong></td>
                      <td><?= date('d F Y, H:i', strtotime($siswa['updated_at'])) ?> WIB</td>
                    </tr>
                  </table>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<style>
@media print {
  .btn, .card-header.bg-primary, .card-header.bg-info, 
  .card-header.bg-success, .card-header.bg-warning, .card-header.bg-secondary {
    display: none !important;
  }
  
  .card {
    border: 1px solid #000 !important;
    margin-bottom: 10px;
  }
  
  .badge {
    border: 1px solid #000 !important;
  }
}
</style>

<?= $this->endSection() ?>