<?= $this->extend('layouts/theme-backend') ?>

<?= $this->section('content') ?>
<h1 class="h2 mb-3 text-gray-900"><?= $title; ?></h1>

<div id="content">
   <div class="card shadow mb-4">
      <div class="card-body">
         <?= form_open_multipart('/admin/artikel/create') ?>
         <?= csrf_field(); ?>
         <div class="row">
            <div class="col-md-12">
               <div class="form-group">
                  <label for="judul">Judul Berita</label>
                  <input type="text" name="judul" id="judul" class="form-control <?= (validation_show_error('judul') ? "is-invalid" : "") ?>" value="<?= set_value('judul') ?>">
                  <div class="invalid-feedback">
                     <?= validation_show_error('judul') ?>
                  </div>
               </div>
               <div class="form-group">
                  <label for="isi">Isi Berita</label>
                  <textarea name="isi" id="isi" class="form-control <?= (validation_show_error('isi') ? "is-invalid" : "") ?>" placeholder="isi artikel..." value="<?= set_value('isi') ?>"></textarea>
                  <div class="invalid-feedback">
                     <?= validation_show_error('isi') ?>
                  </div>
               </div>
               <div class="form-group">
                  <label for="foto_artikel">Foto <small>(Format .jpg, .jpeg, .png)</small></label>
                  <input type="file" name="foto_artikel" id="foto_artikel" class="form-control-file <?= (validation_show_error('foto_artikel') ? "is-invalid" : "") ?>" onchange="readFoto(event)">
                  <div class="invalid-feedback">
                     <?= validation_show_error('foto_artikel') ?>
                  </div>
                  <img id='output' class="mt-3 mb-0" style="width: 400px;">
               </div>
               <div class="form-group mt-4">
                  <button type="submit" class="btn btn-primary btn-lg">Simpan</button>
               </div>
            </div>
         </div>
         <?= form_close(); ?>
      </div>
   </div>
</div>
<?= $this->endSection() ?>